// Code generated by go-swagger; DO NOT EDIT.

package groups_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewGroupsServiceListGroupMembersParams creates a new GroupsServiceListGroupMembersParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGroupsServiceListGroupMembersParams() *GroupsServiceListGroupMembersParams {
	return &GroupsServiceListGroupMembersParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGroupsServiceListGroupMembersParamsWithTimeout creates a new GroupsServiceListGroupMembersParams object
// with the ability to set a timeout on a request.
func NewGroupsServiceListGroupMembersParamsWithTimeout(timeout time.Duration) *GroupsServiceListGroupMembersParams {
	return &GroupsServiceListGroupMembersParams{
		timeout: timeout,
	}
}

// NewGroupsServiceListGroupMembersParamsWithContext creates a new GroupsServiceListGroupMembersParams object
// with the ability to set a context for a request.
func NewGroupsServiceListGroupMembersParamsWithContext(ctx context.Context) *GroupsServiceListGroupMembersParams {
	return &GroupsServiceListGroupMembersParams{
		Context: ctx,
	}
}

// NewGroupsServiceListGroupMembersParamsWithHTTPClient creates a new GroupsServiceListGroupMembersParams object
// with the ability to set a custom HTTPClient for a request.
func NewGroupsServiceListGroupMembersParamsWithHTTPClient(client *http.Client) *GroupsServiceListGroupMembersParams {
	return &GroupsServiceListGroupMembersParams{
		HTTPClient: client,
	}
}

/*
GroupsServiceListGroupMembersParams contains all the parameters to send to the API endpoint

	for the groups service list group members operation.

	Typically these are written to a http.Request.
*/
type GroupsServiceListGroupMembersParams struct {

	/* PaginationNextPageToken.

	     Specifies a page token to use to retrieve the next page. Set this to the
	`next_page_token` returned by previous list requests to get the next page of
	results. If set, `previous_page_token` must not be set.
	*/
	PaginationNextPageToken *string

	/* PaginationPageSize.

	     The max number of results per page that should be returned. If the number
	of available results is larger than `page_size`, a `next_page_token` is
	returned which can be used to get the next page of results in subsequent
	requests. A value of zero will cause `page_size` to be defaulted.

	     Format: int64
	*/
	PaginationPageSize *int64

	/* PaginationPreviousPageToken.

	     Specifies a page token to use to retrieve the previous page. Set this to
	the `previous_page_token` returned by previous list requests to get the
	previous page of results. If set, `next_page_token` must not be set.
	*/
	PaginationPreviousPageToken *string

	/* ResourceName.

	     resource_name is the resource name of the group.
	iam/organization/<org_id>/group/<group_id>.
	*/
	ResourceName string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the groups service list group members params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupsServiceListGroupMembersParams) WithDefaults() *GroupsServiceListGroupMembersParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the groups service list group members params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GroupsServiceListGroupMembersParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the groups service list group members params
func (o *GroupsServiceListGroupMembersParams) WithTimeout(timeout time.Duration) *GroupsServiceListGroupMembersParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the groups service list group members params
func (o *GroupsServiceListGroupMembersParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the groups service list group members params
func (o *GroupsServiceListGroupMembersParams) WithContext(ctx context.Context) *GroupsServiceListGroupMembersParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the groups service list group members params
func (o *GroupsServiceListGroupMembersParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the groups service list group members params
func (o *GroupsServiceListGroupMembersParams) WithHTTPClient(client *http.Client) *GroupsServiceListGroupMembersParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the groups service list group members params
func (o *GroupsServiceListGroupMembersParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithPaginationNextPageToken adds the paginationNextPageToken to the groups service list group members params
func (o *GroupsServiceListGroupMembersParams) WithPaginationNextPageToken(paginationNextPageToken *string) *GroupsServiceListGroupMembersParams {
	o.SetPaginationNextPageToken(paginationNextPageToken)
	return o
}

// SetPaginationNextPageToken adds the paginationNextPageToken to the groups service list group members params
func (o *GroupsServiceListGroupMembersParams) SetPaginationNextPageToken(paginationNextPageToken *string) {
	o.PaginationNextPageToken = paginationNextPageToken
}

// WithPaginationPageSize adds the paginationPageSize to the groups service list group members params
func (o *GroupsServiceListGroupMembersParams) WithPaginationPageSize(paginationPageSize *int64) *GroupsServiceListGroupMembersParams {
	o.SetPaginationPageSize(paginationPageSize)
	return o
}

// SetPaginationPageSize adds the paginationPageSize to the groups service list group members params
func (o *GroupsServiceListGroupMembersParams) SetPaginationPageSize(paginationPageSize *int64) {
	o.PaginationPageSize = paginationPageSize
}

// WithPaginationPreviousPageToken adds the paginationPreviousPageToken to the groups service list group members params
func (o *GroupsServiceListGroupMembersParams) WithPaginationPreviousPageToken(paginationPreviousPageToken *string) *GroupsServiceListGroupMembersParams {
	o.SetPaginationPreviousPageToken(paginationPreviousPageToken)
	return o
}

// SetPaginationPreviousPageToken adds the paginationPreviousPageToken to the groups service list group members params
func (o *GroupsServiceListGroupMembersParams) SetPaginationPreviousPageToken(paginationPreviousPageToken *string) {
	o.PaginationPreviousPageToken = paginationPreviousPageToken
}

// WithResourceName adds the resourceName to the groups service list group members params
func (o *GroupsServiceListGroupMembersParams) WithResourceName(resourceName string) *GroupsServiceListGroupMembersParams {
	o.SetResourceName(resourceName)
	return o
}

// SetResourceName adds the resourceName to the groups service list group members params
func (o *GroupsServiceListGroupMembersParams) SetResourceName(resourceName string) {
	o.ResourceName = resourceName
}

// WriteToRequest writes these params to a swagger request
func (o *GroupsServiceListGroupMembersParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.PaginationNextPageToken != nil {

		// query param pagination.next_page_token
		var qrPaginationNextPageToken string

		if o.PaginationNextPageToken != nil {
			qrPaginationNextPageToken = *o.PaginationNextPageToken
		}
		qPaginationNextPageToken := qrPaginationNextPageToken
		if qPaginationNextPageToken != "" {

			if err := r.SetQueryParam("pagination.next_page_token", qPaginationNextPageToken); err != nil {
				return err
			}
		}
	}

	if o.PaginationPageSize != nil {

		// query param pagination.page_size
		var qrPaginationPageSize int64

		if o.PaginationPageSize != nil {
			qrPaginationPageSize = *o.PaginationPageSize
		}
		qPaginationPageSize := swag.FormatInt64(qrPaginationPageSize)
		if qPaginationPageSize != "" {

			if err := r.SetQueryParam("pagination.page_size", qPaginationPageSize); err != nil {
				return err
			}
		}
	}

	if o.PaginationPreviousPageToken != nil {

		// query param pagination.previous_page_token
		var qrPaginationPreviousPageToken string

		if o.PaginationPreviousPageToken != nil {
			qrPaginationPreviousPageToken = *o.PaginationPreviousPageToken
		}
		qPaginationPreviousPageToken := qrPaginationPreviousPageToken
		if qPaginationPreviousPageToken != "" {

			if err := r.SetQueryParam("pagination.previous_page_token", qPaginationPreviousPageToken); err != nil {
				return err
			}
		}
	}

	// path param resource_name
	if err := r.SetPathParam("resource_name", o.ResourceName); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
