// Code generated by go-swagger; DO NOT EDIT.

package log_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-log-service/preview/2021-03-30/models"
)

// LogServiceCreateArchiveReader is a Reader for the LogServiceCreateArchive structure.
type LogServiceCreateArchiveReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LogServiceCreateArchiveReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLogServiceCreateArchiveOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLogServiceCreateArchiveDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLogServiceCreateArchiveOK creates a LogServiceCreateArchiveOK with default headers values
func NewLogServiceCreateArchiveOK() *LogServiceCreateArchiveOK {
	return &LogServiceCreateArchiveOK{}
}

/*
LogServiceCreateArchiveOK describes a response with status code 200, with default header values.

A successful response.
*/
type LogServiceCreateArchiveOK struct {
	Payload *models.LogService20210330CreateArchiveResponse
}

// IsSuccess returns true when this log service create archive o k response has a 2xx status code
func (o *LogServiceCreateArchiveOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this log service create archive o k response has a 3xx status code
func (o *LogServiceCreateArchiveOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this log service create archive o k response has a 4xx status code
func (o *LogServiceCreateArchiveOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this log service create archive o k response has a 5xx status code
func (o *LogServiceCreateArchiveOK) IsServerError() bool {
	return false
}

// IsCode returns true when this log service create archive o k response a status code equal to that given
func (o *LogServiceCreateArchiveOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the log service create archive o k response
func (o *LogServiceCreateArchiveOK) Code() int {
	return 200
}

func (o *LogServiceCreateArchiveOK) Error() string {
	return fmt.Sprintf("[POST /logs/2021-03-30/organizations/{resource.location.organization_id}/projects/{resource.location.project_id}/resources/{resource.id}/archives][%d] logServiceCreateArchiveOK  %+v", 200, o.Payload)
}

func (o *LogServiceCreateArchiveOK) String() string {
	return fmt.Sprintf("[POST /logs/2021-03-30/organizations/{resource.location.organization_id}/projects/{resource.location.project_id}/resources/{resource.id}/archives][%d] logServiceCreateArchiveOK  %+v", 200, o.Payload)
}

func (o *LogServiceCreateArchiveOK) GetPayload() *models.LogService20210330CreateArchiveResponse {
	return o.Payload
}

func (o *LogServiceCreateArchiveOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LogService20210330CreateArchiveResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLogServiceCreateArchiveDefault creates a LogServiceCreateArchiveDefault with default headers values
func NewLogServiceCreateArchiveDefault(code int) *LogServiceCreateArchiveDefault {
	return &LogServiceCreateArchiveDefault{
		_statusCode: code,
	}
}

/*
LogServiceCreateArchiveDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type LogServiceCreateArchiveDefault struct {
	_statusCode int

	Payload *models.RuntimeError
}

// IsSuccess returns true when this log service create archive default response has a 2xx status code
func (o *LogServiceCreateArchiveDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this log service create archive default response has a 3xx status code
func (o *LogServiceCreateArchiveDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this log service create archive default response has a 4xx status code
func (o *LogServiceCreateArchiveDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this log service create archive default response has a 5xx status code
func (o *LogServiceCreateArchiveDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this log service create archive default response a status code equal to that given
func (o *LogServiceCreateArchiveDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the log service create archive default response
func (o *LogServiceCreateArchiveDefault) Code() int {
	return o._statusCode
}

func (o *LogServiceCreateArchiveDefault) Error() string {
	return fmt.Sprintf("[POST /logs/2021-03-30/organizations/{resource.location.organization_id}/projects/{resource.location.project_id}/resources/{resource.id}/archives][%d] LogService_CreateArchive default  %+v", o._statusCode, o.Payload)
}

func (o *LogServiceCreateArchiveDefault) String() string {
	return fmt.Sprintf("[POST /logs/2021-03-30/organizations/{resource.location.organization_id}/projects/{resource.location.project_id}/resources/{resource.id}/archives][%d] LogService_CreateArchive default  %+v", o._statusCode, o.Payload)
}

func (o *LogServiceCreateArchiveDefault) GetPayload() *models.RuntimeError {
	return o.Payload
}

func (o *LogServiceCreateArchiveDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
