// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// LogService20210330Destination Destination represents a destination to which to stream log events to.
//
// swagger:model log_service_20210330Destination
type LogService20210330Destination struct {

	// cloudwatchlogs_provider represents a cloudwatch provider.
	CloudwatchlogsProvider *LogService20210330CloudwatchLogsProvider `json:"cloudwatchlogs_provider,omitempty"`

	// datadog_provider represents a datadog provider.
	DatadogProvider *LogService20210330DatadogProvider `json:"datadog_provider,omitempty"`

	// endpoint represents the endpoint that the destination is configured to stream to
	Endpoint string `json:"endpoint,omitempty"`

	// filter represents the filters that are attached to the destination record.
	Filter *CloudlogService20210330Filter `json:"filter,omitempty"`

	// in_error represents if the HCP platform is currently failing to stream to the destination.
	InError bool `json:"in_error,omitempty"`

	// last_error_message represents the error message from the response of the last streaming request sent to the destination.
	LastErrorMessage string `json:"last_error_message,omitempty"`

	// name represents the human readable name of a destination
	Name string `json:"name,omitempty"`

	// resource represents the destination record in the form of an HCP resource.
	Resource *LocationLink `json:"resource,omitempty"`

	// splunk_cloud_provider represents a splunk cloud provider.
	SplunkCloudProvider *LogService20210330SplunkCloudProvider `json:"splunk_cloud_provider,omitempty"`

	// status destination status field error/pending/success
	Status string `json:"status,omitempty"`
}

// Validate validates this log service 20210330 destination
func (m *LogService20210330Destination) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCloudwatchlogsProvider(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDatadogProvider(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateFilter(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateResource(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSplunkCloudProvider(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330Destination) validateCloudwatchlogsProvider(formats strfmt.Registry) error {
	if swag.IsZero(m.CloudwatchlogsProvider) { // not required
		return nil
	}

	if m.CloudwatchlogsProvider != nil {
		if err := m.CloudwatchlogsProvider.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloudwatchlogs_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cloudwatchlogs_provider")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330Destination) validateDatadogProvider(formats strfmt.Registry) error {
	if swag.IsZero(m.DatadogProvider) { // not required
		return nil
	}

	if m.DatadogProvider != nil {
		if err := m.DatadogProvider.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("datadog_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("datadog_provider")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330Destination) validateFilter(formats strfmt.Registry) error {
	if swag.IsZero(m.Filter) { // not required
		return nil
	}

	if m.Filter != nil {
		if err := m.Filter.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("filter")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("filter")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330Destination) validateResource(formats strfmt.Registry) error {
	if swag.IsZero(m.Resource) { // not required
		return nil
	}

	if m.Resource != nil {
		if err := m.Resource.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("resource")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330Destination) validateSplunkCloudProvider(formats strfmt.Registry) error {
	if swag.IsZero(m.SplunkCloudProvider) { // not required
		return nil
	}

	if m.SplunkCloudProvider != nil {
		if err := m.SplunkCloudProvider.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("splunk_cloud_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("splunk_cloud_provider")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this log service 20210330 destination based on the context it is used
func (m *LogService20210330Destination) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCloudwatchlogsProvider(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDatadogProvider(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateFilter(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateResource(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSplunkCloudProvider(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330Destination) contextValidateCloudwatchlogsProvider(ctx context.Context, formats strfmt.Registry) error {

	if m.CloudwatchlogsProvider != nil {

		if swag.IsZero(m.CloudwatchlogsProvider) { // not required
			return nil
		}

		if err := m.CloudwatchlogsProvider.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("cloudwatchlogs_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("cloudwatchlogs_provider")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330Destination) contextValidateDatadogProvider(ctx context.Context, formats strfmt.Registry) error {

	if m.DatadogProvider != nil {

		if swag.IsZero(m.DatadogProvider) { // not required
			return nil
		}

		if err := m.DatadogProvider.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("datadog_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("datadog_provider")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330Destination) contextValidateFilter(ctx context.Context, formats strfmt.Registry) error {

	if m.Filter != nil {

		if swag.IsZero(m.Filter) { // not required
			return nil
		}

		if err := m.Filter.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("filter")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("filter")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330Destination) contextValidateResource(ctx context.Context, formats strfmt.Registry) error {

	if m.Resource != nil {

		if swag.IsZero(m.Resource) { // not required
			return nil
		}

		if err := m.Resource.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("resource")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("resource")
			}
			return err
		}
	}

	return nil
}

func (m *LogService20210330Destination) contextValidateSplunkCloudProvider(ctx context.Context, formats strfmt.Registry) error {

	if m.SplunkCloudProvider != nil {

		if swag.IsZero(m.SplunkCloudProvider) { // not required
			return nil
		}

		if err := m.SplunkCloudProvider.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("splunk_cloud_provider")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("splunk_cloud_provider")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *LogService20210330Destination) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LogService20210330Destination) UnmarshalBinary(b []byte) error {
	var res LogService20210330Destination
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
