// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2021-04-30/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceDeleteRegistryReader is a Reader for the PackerServiceDeleteRegistry structure.
type PackerServiceDeleteRegistryReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceDeleteRegistryReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceDeleteRegistryOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceDeleteRegistryDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceDeleteRegistryOK creates a PackerServiceDeleteRegistryOK with default headers values
func NewPackerServiceDeleteRegistryOK() *PackerServiceDeleteRegistryOK {
	return &PackerServiceDeleteRegistryOK{}
}

/*
PackerServiceDeleteRegistryOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceDeleteRegistryOK struct {
	Payload *models.HashicorpCloudPackerDeleteRegistryResponse
}

// IsSuccess returns true when this packer service delete registry o k response has a 2xx status code
func (o *PackerServiceDeleteRegistryOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service delete registry o k response has a 3xx status code
func (o *PackerServiceDeleteRegistryOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service delete registry o k response has a 4xx status code
func (o *PackerServiceDeleteRegistryOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service delete registry o k response has a 5xx status code
func (o *PackerServiceDeleteRegistryOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service delete registry o k response a status code equal to that given
func (o *PackerServiceDeleteRegistryOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the packer service delete registry o k response
func (o *PackerServiceDeleteRegistryOK) Code() int {
	return 200
}

func (o *PackerServiceDeleteRegistryOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/registry][%d] packerServiceDeleteRegistryOK %s", 200, payload)
}

func (o *PackerServiceDeleteRegistryOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/registry][%d] packerServiceDeleteRegistryOK %s", 200, payload)
}

func (o *PackerServiceDeleteRegistryOK) GetPayload() *models.HashicorpCloudPackerDeleteRegistryResponse {
	return o.Payload
}

func (o *PackerServiceDeleteRegistryOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPackerDeleteRegistryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceDeleteRegistryDefault creates a PackerServiceDeleteRegistryDefault with default headers values
func NewPackerServiceDeleteRegistryDefault(code int) *PackerServiceDeleteRegistryDefault {
	return &PackerServiceDeleteRegistryDefault{
		_statusCode: code,
	}
}

/*
PackerServiceDeleteRegistryDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceDeleteRegistryDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this packer service delete registry default response has a 2xx status code
func (o *PackerServiceDeleteRegistryDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service delete registry default response has a 3xx status code
func (o *PackerServiceDeleteRegistryDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service delete registry default response has a 4xx status code
func (o *PackerServiceDeleteRegistryDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service delete registry default response has a 5xx status code
func (o *PackerServiceDeleteRegistryDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service delete registry default response a status code equal to that given
func (o *PackerServiceDeleteRegistryDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the packer service delete registry default response
func (o *PackerServiceDeleteRegistryDefault) Code() int {
	return o._statusCode
}

func (o *PackerServiceDeleteRegistryDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/registry][%d] PackerService_DeleteRegistry default %s", o._statusCode, payload)
}

func (o *PackerServiceDeleteRegistryDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/registry][%d] PackerService_DeleteRegistry default %s", o._statusCode, payload)
}

func (o *PackerServiceDeleteRegistryDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceDeleteRegistryDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
