// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2023-01-01/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceCreateBuildReader is a Reader for the PackerServiceCreateBuild structure.
type PackerServiceCreateBuildReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceCreateBuildReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceCreateBuildOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceCreateBuildDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceCreateBuildOK creates a PackerServiceCreateBuildOK with default headers values
func NewPackerServiceCreateBuildOK() *PackerServiceCreateBuildOK {
	return &PackerServiceCreateBuildOK{}
}

/*
PackerServiceCreateBuildOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceCreateBuildOK struct {
	Payload *models.HashicorpCloudPacker20230101CreateBuildResponse
}

// IsSuccess returns true when this packer service create build o k response has a 2xx status code
func (o *PackerServiceCreateBuildOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service create build o k response has a 3xx status code
func (o *PackerServiceCreateBuildOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service create build o k response has a 4xx status code
func (o *PackerServiceCreateBuildOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service create build o k response has a 5xx status code
func (o *PackerServiceCreateBuildOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service create build o k response a status code equal to that given
func (o *PackerServiceCreateBuildOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the packer service create build o k response
func (o *PackerServiceCreateBuildOK) Code() int {
	return 200
}

func (o *PackerServiceCreateBuildOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds][%d] packerServiceCreateBuildOK %s", 200, payload)
}

func (o *PackerServiceCreateBuildOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds][%d] packerServiceCreateBuildOK %s", 200, payload)
}

func (o *PackerServiceCreateBuildOK) GetPayload() *models.HashicorpCloudPacker20230101CreateBuildResponse {
	return o.Payload
}

func (o *PackerServiceCreateBuildOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPacker20230101CreateBuildResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceCreateBuildDefault creates a PackerServiceCreateBuildDefault with default headers values
func NewPackerServiceCreateBuildDefault(code int) *PackerServiceCreateBuildDefault {
	return &PackerServiceCreateBuildDefault{
		_statusCode: code,
	}
}

/*
PackerServiceCreateBuildDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceCreateBuildDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this packer service create build default response has a 2xx status code
func (o *PackerServiceCreateBuildDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service create build default response has a 3xx status code
func (o *PackerServiceCreateBuildDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service create build default response has a 4xx status code
func (o *PackerServiceCreateBuildDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service create build default response has a 5xx status code
func (o *PackerServiceCreateBuildDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service create build default response a status code equal to that given
func (o *PackerServiceCreateBuildDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the packer service create build default response
func (o *PackerServiceCreateBuildDefault) Code() int {
	return o._statusCode
}

func (o *PackerServiceCreateBuildDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds][%d] PackerService_CreateBuild default %s", o._statusCode, payload)
}

func (o *PackerServiceCreateBuildDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds][%d] PackerService_CreateBuild default %s", o._statusCode, payload)
}

func (o *PackerServiceCreateBuildDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceCreateBuildDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
