// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2023-01-01/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceGetSbomReader is a Reader for the PackerServiceGetSbom structure.
type PackerServiceGetSbomReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceGetSbomReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceGetSbomOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceGetSbomDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceGetSbomOK creates a PackerServiceGetSbomOK with default headers values
func NewPackerServiceGetSbomOK() *PackerServiceGetSbomOK {
	return &PackerServiceGetSbomOK{}
}

/*
PackerServiceGetSbomOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceGetSbomOK struct {
	Payload *models.HashicorpCloudPacker20230101GetSbomResponse
}

// IsSuccess returns true when this packer service get sbom o k response has a 2xx status code
func (o *PackerServiceGetSbomOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service get sbom o k response has a 3xx status code
func (o *PackerServiceGetSbomOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service get sbom o k response has a 4xx status code
func (o *PackerServiceGetSbomOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service get sbom o k response has a 5xx status code
func (o *PackerServiceGetSbomOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service get sbom o k response a status code equal to that given
func (o *PackerServiceGetSbomOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the packer service get sbom o k response
func (o *PackerServiceGetSbomOK) Code() int {
	return 200
}

func (o *PackerServiceGetSbomOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}/sboms/{sbom_name}][%d] packerServiceGetSbomOK %s", 200, payload)
}

func (o *PackerServiceGetSbomOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}/sboms/{sbom_name}][%d] packerServiceGetSbomOK %s", 200, payload)
}

func (o *PackerServiceGetSbomOK) GetPayload() *models.HashicorpCloudPacker20230101GetSbomResponse {
	return o.Payload
}

func (o *PackerServiceGetSbomOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPacker20230101GetSbomResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceGetSbomDefault creates a PackerServiceGetSbomDefault with default headers values
func NewPackerServiceGetSbomDefault(code int) *PackerServiceGetSbomDefault {
	return &PackerServiceGetSbomDefault{
		_statusCode: code,
	}
}

/*
PackerServiceGetSbomDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceGetSbomDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this packer service get sbom default response has a 2xx status code
func (o *PackerServiceGetSbomDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service get sbom default response has a 3xx status code
func (o *PackerServiceGetSbomDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service get sbom default response has a 4xx status code
func (o *PackerServiceGetSbomDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service get sbom default response has a 5xx status code
func (o *PackerServiceGetSbomDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service get sbom default response a status code equal to that given
func (o *PackerServiceGetSbomDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the packer service get sbom default response
func (o *PackerServiceGetSbomDefault) Code() int {
	return o._statusCode
}

func (o *PackerServiceGetSbomDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}/sboms/{sbom_name}][%d] PackerService_GetSbom default %s", o._statusCode, payload)
}

func (o *PackerServiceGetSbomDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /packer/2023-01-01/organizations/{location.organization_id}/projects/{location.project_id}/buckets/{bucket_name}/versions/{fingerprint}/builds/{build_id}/sboms/{sbom_name}][%d] PackerService_GetSbom default %s", o._statusCode, payload)
}

func (o *PackerServiceGetSbomDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceGetSbomDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
