// Code generated by go-swagger; DO NOT EDIT.

package resource_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	httptransport "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// New creates a new resource service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

// New creates a new resource service API client with basic auth credentials.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - user: user for basic authentication header.
// - password: password for basic authentication header.
func NewClientWithBasicAuth(host, basePath, scheme, user, password string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BasicAuth(user, password)
	return &Client{transport: transport, formats: strfmt.Default}
}

// New creates a new resource service API client with a bearer token for authentication.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - bearerToken: bearer token for Bearer authentication header.
func NewClientWithBearerToken(host, basePath, scheme, bearerToken string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BearerToken(bearerToken)
	return &Client{transport: transport, formats: strfmt.Default}
}

/*
Client for resource service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption may be used to customize the behavior of Client methods.
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	ResourceServiceGetIamPolicy(params *ResourceServiceGetIamPolicyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceServiceGetIamPolicyOK, error)

	ResourceServiceGetResource(params *ResourceServiceGetResourceParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceServiceGetResourceOK, error)

	ResourceServiceList(params *ResourceServiceListParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceServiceListOK, error)

	ResourceServiceListAccessibleResources(params *ResourceServiceListAccessibleResourcesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceServiceListAccessibleResourcesOK, error)

	ResourceServiceListRoles(params *ResourceServiceListRolesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceServiceListRolesOK, error)

	ResourceServiceSetIamPolicy(params *ResourceServiceSetIamPolicyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceServiceSetIamPolicyOK, error)

	ResourceServiceTestIamPermissions(params *ResourceServiceTestIamPermissionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceServiceTestIamPermissionsOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
ResourceServiceGetIamPolicy gets iam policy gets the i a m policy for a resource
*/
func (a *Client) ResourceServiceGetIamPolicy(params *ResourceServiceGetIamPolicyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceServiceGetIamPolicyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewResourceServiceGetIamPolicyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ResourceService_GetIamPolicy",
		Method:             "GET",
		PathPattern:        "/2019-12-10/resource-manager/resources/iam-policy",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ResourceServiceGetIamPolicyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ResourceServiceGetIamPolicyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ResourceServiceGetIamPolicyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ResourceServiceGetResource gets resource retrieves a resource
*/
func (a *Client) ResourceServiceGetResource(params *ResourceServiceGetResourceParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceServiceGetResourceOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewResourceServiceGetResourceParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ResourceService_GetResource",
		Method:             "GET",
		PathPattern:        "/resource-manager/2019-12-10/resource",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ResourceServiceGetResourceReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ResourceServiceGetResourceOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ResourceServiceGetResourceDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ResourceServiceList lists lists the resources the caller has access to
*/
func (a *Client) ResourceServiceList(params *ResourceServiceListParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceServiceListOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewResourceServiceListParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ResourceService_List",
		Method:             "GET",
		PathPattern:        "/resource-manager/2019-12-10/resources",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ResourceServiceListReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ResourceServiceListOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ResourceServiceListDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ResourceServiceListAccessibleResources lists accessible resources lists the resources the caller has access to at and below the given scope
*/
func (a *Client) ResourceServiceListAccessibleResources(params *ResourceServiceListAccessibleResourcesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceServiceListAccessibleResourcesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewResourceServiceListAccessibleResourcesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ResourceService_ListAccessibleResources",
		Method:             "GET",
		PathPattern:        "/resource-manager/2019-12-10/resources/accessible",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ResourceServiceListAccessibleResourcesReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ResourceServiceListAccessibleResourcesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ResourceServiceListAccessibleResourcesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ResourceServiceListRoles lists roles lists roles applicable on the given resource requires caller to have resource manager resource list roles permission on the given resource
*/
func (a *Client) ResourceServiceListRoles(params *ResourceServiceListRolesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceServiceListRolesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewResourceServiceListRolesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ResourceService_ListRoles",
		Method:             "GET",
		PathPattern:        "/resource-manager/2019-12-10/resource/roles",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ResourceServiceListRolesReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ResourceServiceListRolesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ResourceServiceListRolesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ResourceServiceSetIamPolicy sets iam policy sets the i a m policy for a resource since this updates the full policy the policy takes an etag argument that should match with the current policy stored in the system this is to avoid concurrent writes erasing each other s data hence the client should always get the current policy that includes the etag modify the policy and then set the policy with the same etag if there is no existing policy the etag must be empty
*/
func (a *Client) ResourceServiceSetIamPolicy(params *ResourceServiceSetIamPolicyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceServiceSetIamPolicyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewResourceServiceSetIamPolicyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ResourceService_SetIamPolicy",
		Method:             "PUT",
		PathPattern:        "/2019-12-10/resource-manager/resources/iam-policy",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ResourceServiceSetIamPolicyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ResourceServiceSetIamPolicyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ResourceServiceSetIamPolicyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ResourceServiceTestIamPermissions tests iam permissions returns a subset of the request permissions the calling principal has on the resource
*/
func (a *Client) ResourceServiceTestIamPermissions(params *ResourceServiceTestIamPermissionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ResourceServiceTestIamPermissionsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewResourceServiceTestIamPermissionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ResourceService_TestIamPermissions",
		Method:             "POST",
		PathPattern:        "/resource-manager/2019-12-10/resources/test-iam-permissions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ResourceServiceTestIamPermissionsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ResourceServiceTestIamPermissionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ResourceServiceTestIamPermissionsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
