// Code generated by go-swagger; DO NOT EDIT.

package registry_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewReadBoxParams creates a new ReadBoxParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewReadBoxParams() *ReadBoxParams {
	return &ReadBoxParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewReadBoxParamsWithTimeout creates a new ReadBoxParams object
// with the ability to set a timeout on a request.
func NewReadBoxParamsWithTimeout(timeout time.Duration) *ReadBoxParams {
	return &ReadBoxParams{
		timeout: timeout,
	}
}

// NewReadBoxParamsWithContext creates a new ReadBoxParams object
// with the ability to set a context for a request.
func NewReadBoxParamsWithContext(ctx context.Context) *ReadBoxParams {
	return &ReadBoxParams{
		Context: ctx,
	}
}

// NewReadBoxParamsWithHTTPClient creates a new ReadBoxParams object
// with the ability to set a custom HTTPClient for a request.
func NewReadBoxParamsWithHTTPClient(client *http.Client) *ReadBoxParams {
	return &ReadBoxParams{
		HTTPClient: client,
	}
}

/*
ReadBoxParams contains all the parameters to send to the API endpoint

	for the read box operation.

	Typically these are written to a http.Request.
*/
type ReadBoxParams struct {

	/* Box.

	     The name segment of the Box to look up. As an example, this field would
	represent the "vagrant" in "hashicorp/vagrant".
	*/
	Box string

	/* Expanded.

	   Expand the box child elements.
	*/
	Expanded *bool

	/* Registry.

	     The Registry segment of the Box. As an example, this field would represent
	the "hashicorp" in "hashicorp/vagrant".
	*/
	Registry string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the read box params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ReadBoxParams) WithDefaults() *ReadBoxParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the read box params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *ReadBoxParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the read box params
func (o *ReadBoxParams) WithTimeout(timeout time.Duration) *ReadBoxParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the read box params
func (o *ReadBoxParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the read box params
func (o *ReadBoxParams) WithContext(ctx context.Context) *ReadBoxParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the read box params
func (o *ReadBoxParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the read box params
func (o *ReadBoxParams) WithHTTPClient(client *http.Client) *ReadBoxParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the read box params
func (o *ReadBoxParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBox adds the box to the read box params
func (o *ReadBoxParams) WithBox(box string) *ReadBoxParams {
	o.SetBox(box)
	return o
}

// SetBox adds the box to the read box params
func (o *ReadBoxParams) SetBox(box string) {
	o.Box = box
}

// WithExpanded adds the expanded to the read box params
func (o *ReadBoxParams) WithExpanded(expanded *bool) *ReadBoxParams {
	o.SetExpanded(expanded)
	return o
}

// SetExpanded adds the expanded to the read box params
func (o *ReadBoxParams) SetExpanded(expanded *bool) {
	o.Expanded = expanded
}

// WithRegistry adds the registry to the read box params
func (o *ReadBoxParams) WithRegistry(registry string) *ReadBoxParams {
	o.SetRegistry(registry)
	return o
}

// SetRegistry adds the registry to the read box params
func (o *ReadBoxParams) SetRegistry(registry string) {
	o.Registry = registry
}

// WriteToRequest writes these params to a swagger request
func (o *ReadBoxParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param box
	if err := r.SetPathParam("box", o.Box); err != nil {
		return err
	}

	if o.Expanded != nil {

		// query param expanded
		var qrExpanded bool

		if o.Expanded != nil {
			qrExpanded = *o.Expanded
		}
		qExpanded := swag.FormatBool(qrExpanded)
		if qExpanded != "" {

			if err := r.SetQueryParam("expanded", qExpanded); err != nil {
				return err
			}
		}
	}

	// path param registry
	if err := r.SetPathParam("registry", o.Registry); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
