// Code generated by go-swagger; DO NOT EDIT.

package tenant_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-radar/preview/2023-05-01/models"
)

// ProvisionTenantReader is a Reader for the ProvisionTenant structure.
type ProvisionTenantReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ProvisionTenantReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewProvisionTenantOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewProvisionTenantDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewProvisionTenantOK creates a ProvisionTenantOK with default headers values
func NewProvisionTenantOK() *ProvisionTenantOK {
	return &ProvisionTenantOK{}
}

/*
ProvisionTenantOK describes a response with status code 200, with default header values.

A successful response.
*/
type ProvisionTenantOK struct {
	Payload interface{}
}

// IsSuccess returns true when this provision tenant o k response has a 2xx status code
func (o *ProvisionTenantOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this provision tenant o k response has a 3xx status code
func (o *ProvisionTenantOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this provision tenant o k response has a 4xx status code
func (o *ProvisionTenantOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this provision tenant o k response has a 5xx status code
func (o *ProvisionTenantOK) IsServerError() bool {
	return false
}

// IsCode returns true when this provision tenant o k response a status code equal to that given
func (o *ProvisionTenantOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the provision tenant o k response
func (o *ProvisionTenantOK) Code() int {
	return 200
}

func (o *ProvisionTenantOK) Error() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/tenants/provision][%d] provisionTenantOK  %+v", 200, o.Payload)
}

func (o *ProvisionTenantOK) String() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/tenants/provision][%d] provisionTenantOK  %+v", 200, o.Payload)
}

func (o *ProvisionTenantOK) GetPayload() interface{} {
	return o.Payload
}

func (o *ProvisionTenantOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewProvisionTenantDefault creates a ProvisionTenantDefault with default headers values
func NewProvisionTenantDefault(code int) *ProvisionTenantDefault {
	return &ProvisionTenantDefault{
		_statusCode: code,
	}
}

/*
ProvisionTenantDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ProvisionTenantDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this provision tenant default response has a 2xx status code
func (o *ProvisionTenantDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this provision tenant default response has a 3xx status code
func (o *ProvisionTenantDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this provision tenant default response has a 4xx status code
func (o *ProvisionTenantDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this provision tenant default response has a 5xx status code
func (o *ProvisionTenantDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this provision tenant default response a status code equal to that given
func (o *ProvisionTenantDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the provision tenant default response
func (o *ProvisionTenantDefault) Code() int {
	return o._statusCode
}

func (o *ProvisionTenantDefault) Error() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/tenants/provision][%d] ProvisionTenant default  %+v", o._statusCode, o.Payload)
}

func (o *ProvisionTenantDefault) String() string {
	return fmt.Sprintf("[POST /2023-05-01/vault-radar/projects/{location.project_id}/tenants/provision][%d] ProvisionTenant default  %+v", o._statusCode, o.Payload)
}

func (o *ProvisionTenantDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *ProvisionTenantDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
ProvisionTenantBody provision tenant body
swagger:model ProvisionTenantBody
*/
type ProvisionTenantBody struct {

	// location
	Location *ProvisionTenantParamsBodyLocation `json:"location,omitempty"`
}

// Validate validates this provision tenant body
func (o *ProvisionTenantBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ProvisionTenantBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this provision tenant body based on the context it is used
func (o *ProvisionTenantBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ProvisionTenantBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ProvisionTenantBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ProvisionTenantBody) UnmarshalBinary(b []byte) error {
	var res ProvisionTenantBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
ProvisionTenantParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model ProvisionTenantParamsBodyLocation
*/
type ProvisionTenantParamsBodyLocation struct {

	// organization_id is the id of the organization.
	OrganizationID string `json:"organization_id,omitempty"`

	// region
	Region *models.LocationRegion `json:"region,omitempty"`
}

// Validate validates this provision tenant params body location
func (o *ProvisionTenantParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ProvisionTenantParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this provision tenant params body location based on the context it is used
func (o *ProvisionTenantParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *ProvisionTenantParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *ProvisionTenantParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *ProvisionTenantParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res ProvisionTenantParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
