// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-06-13/models"
)

// DeleteSyncInstallationReader is a Reader for the DeleteSyncInstallation structure.
type DeleteSyncInstallationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteSyncInstallationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeleteSyncInstallationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDeleteSyncInstallationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDeleteSyncInstallationOK creates a DeleteSyncInstallationOK with default headers values
func NewDeleteSyncInstallationOK() *DeleteSyncInstallationOK {
	return &DeleteSyncInstallationOK{}
}

/*
DeleteSyncInstallationOK describes a response with status code 200, with default header values.

A successful response.
*/
type DeleteSyncInstallationOK struct {
	Payload models.Secrets20230613DeleteSyncInstallationResponse
}

// IsSuccess returns true when this delete sync installation o k response has a 2xx status code
func (o *DeleteSyncInstallationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete sync installation o k response has a 3xx status code
func (o *DeleteSyncInstallationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete sync installation o k response has a 4xx status code
func (o *DeleteSyncInstallationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete sync installation o k response has a 5xx status code
func (o *DeleteSyncInstallationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this delete sync installation o k response a status code equal to that given
func (o *DeleteSyncInstallationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the delete sync installation o k response
func (o *DeleteSyncInstallationOK) Code() int {
	return 200
}

func (o *DeleteSyncInstallationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/installations/{name}][%d] deleteSyncInstallationOK %s", 200, payload)
}

func (o *DeleteSyncInstallationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/installations/{name}][%d] deleteSyncInstallationOK %s", 200, payload)
}

func (o *DeleteSyncInstallationOK) GetPayload() models.Secrets20230613DeleteSyncInstallationResponse {
	return o.Payload
}

func (o *DeleteSyncInstallationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteSyncInstallationDefault creates a DeleteSyncInstallationDefault with default headers values
func NewDeleteSyncInstallationDefault(code int) *DeleteSyncInstallationDefault {
	return &DeleteSyncInstallationDefault{
		_statusCode: code,
	}
}

/*
DeleteSyncInstallationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type DeleteSyncInstallationDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this delete sync installation default response has a 2xx status code
func (o *DeleteSyncInstallationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this delete sync installation default response has a 3xx status code
func (o *DeleteSyncInstallationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this delete sync installation default response has a 4xx status code
func (o *DeleteSyncInstallationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this delete sync installation default response has a 5xx status code
func (o *DeleteSyncInstallationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this delete sync installation default response a status code equal to that given
func (o *DeleteSyncInstallationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the delete sync installation default response
func (o *DeleteSyncInstallationDefault) Code() int {
	return o._statusCode
}

func (o *DeleteSyncInstallationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/installations/{name}][%d] DeleteSyncInstallation default %s", o._statusCode, payload)
}

func (o *DeleteSyncInstallationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/installations/{name}][%d] DeleteSyncInstallation default %s", o._statusCode, payload)
}

func (o *DeleteSyncInstallationDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *DeleteSyncInstallationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
