// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	httptransport "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// New creates a new secret service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

// New creates a new secret service API client with basic auth credentials.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - user: user for basic authentication header.
// - password: password for basic authentication header.
func NewClientWithBasicAuth(host, basePath, scheme, user, password string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BasicAuth(user, password)
	return &Client{transport: transport, formats: strfmt.Default}
}

// New creates a new secret service API client with a bearer token for authentication.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - bearerToken: bearer token for Bearer authentication header.
func NewClientWithBearerToken(host, basePath, scheme, bearerToken string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BearerToken(bearerToken)
	return &Client{transport: transport, formats: strfmt.Default}
}

/*
Client for secret service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption may be used to customize the behavior of Client methods.
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	CompleteGitHubInstall(params *CompleteGitHubInstallParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CompleteGitHubInstallOK, error)

	CompleteVercelInstallation(params *CompleteVercelInstallationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CompleteVercelInstallationOK, error)

	ConnectGitHubInstallation(params *ConnectGitHubInstallationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConnectGitHubInstallationOK, error)

	CreateApp(params *CreateAppParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAppOK, error)

	CreateAppKVSecret(params *CreateAppKVSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAppKVSecretOK, error)

	CreateAwsSmSyncIntegration(params *CreateAwsSmSyncIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAwsSmSyncIntegrationOK, error)

	CreateAzureKvSyncIntegration(params *CreateAzureKvSyncIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAzureKvSyncIntegrationOK, error)

	CreateGcpSmSyncIntegration(params *CreateGcpSmSyncIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateGcpSmSyncIntegrationOK, error)

	CreateGhOrgSyncIntegration(params *CreateGhOrgSyncIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateGhOrgSyncIntegrationOK, error)

	CreateGhRepoSyncIntegration(params *CreateGhRepoSyncIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateGhRepoSyncIntegrationOK, error)

	CreateHcpTerraformSyncInstallation(params *CreateHcpTerraformSyncInstallationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateHcpTerraformSyncInstallationOK, error)

	CreateHcpTerraformSyncIntegration(params *CreateHcpTerraformSyncIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateHcpTerraformSyncIntegrationOK, error)

	CreateVercelProjectSyncIntegration(params *CreateVercelProjectSyncIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateVercelProjectSyncIntegrationOK, error)

	DeleteApp(params *DeleteAppParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteAppOK, error)

	DeleteAppSecret(params *DeleteAppSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteAppSecretOK, error)

	DeleteAppSecretVersion(params *DeleteAppSecretVersionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteAppSecretVersionOK, error)

	DeleteSyncInstallation(params *DeleteSyncInstallationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteSyncInstallationOK, error)

	DeleteSyncIntegration(params *DeleteSyncIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteSyncIntegrationOK, error)

	ForceSync(params *ForceSyncParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ForceSyncOK, error)

	GetApp(params *GetAppParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAppOK, error)

	GetAppSecret(params *GetAppSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAppSecretOK, error)

	GetAppSecretVersion(params *GetAppSecretVersionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAppSecretVersionOK, error)

	GetGitHubEnvironments(params *GetGitHubEnvironmentsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetGitHubEnvironmentsOK, error)

	GetGitHubInstallLinks(params *GetGitHubInstallLinksParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetGitHubInstallLinksOK, error)

	GetGitHubRepositories(params *GetGitHubRepositoriesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetGitHubRepositoriesOK, error)

	GetSyncInstallation(params *GetSyncInstallationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetSyncInstallationOK, error)

	GetSyncIntegration(params *GetSyncIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetSyncIntegrationOK, error)

	GetUsage(params *GetUsageParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetUsageOK, error)

	GetUsage2(params *GetUsage2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetUsage2OK, error)

	GetVercelInstallationLink(params *GetVercelInstallationLinkParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetVercelInstallationLinkOK, error)

	ListAppSecretVersions(params *ListAppSecretVersionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListAppSecretVersionsOK, error)

	ListAppSecrets(params *ListAppSecretsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListAppSecretsOK, error)

	ListApps(params *ListAppsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListAppsOK, error)

	ListGitHubInstallations(params *ListGitHubInstallationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListGitHubInstallationsOK, error)

	ListOpenAppSecretVersions(params *ListOpenAppSecretVersionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListOpenAppSecretVersionsOK, error)

	ListSyncInstallations(params *ListSyncInstallationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListSyncInstallationsOK, error)

	ListSyncIntegrations(params *ListSyncIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListSyncIntegrationsOK, error)

	OpenAppSecret(params *OpenAppSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OpenAppSecretOK, error)

	OpenAppSecretVersion(params *OpenAppSecretVersionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OpenAppSecretVersionOK, error)

	OpenAppSecrets(params *OpenAppSecretsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OpenAppSecretsOK, error)

	SetTier(params *SetTierParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SetTierOK, error)

	UpdateApp(params *UpdateAppParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateAppOK, error)

	UpdateSyncInstallation(params *UpdateSyncInstallationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateSyncInstallationOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
CompleteGitHubInstall complete git hub install API
*/
func (a *Client) CompleteGitHubInstall(params *CompleteGitHubInstallParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CompleteGitHubInstallOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCompleteGitHubInstallParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CompleteGitHubInstall",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/sync/github/callback",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CompleteGitHubInstallReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CompleteGitHubInstallOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CompleteGitHubInstallDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CompleteVercelInstallation complete vercel installation API
*/
func (a *Client) CompleteVercelInstallation(params *CompleteVercelInstallationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CompleteVercelInstallationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCompleteVercelInstallationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CompleteVercelInstallation",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/sync/vercel/callback",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CompleteVercelInstallationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CompleteVercelInstallationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CompleteVercelInstallationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ConnectGitHubInstallation connect git hub installation API
*/
func (a *Client) ConnectGitHubInstallation(params *ConnectGitHubInstallationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ConnectGitHubInstallationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewConnectGitHubInstallationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ConnectGitHubInstallation",
		Method:             "POST",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/github/installations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ConnectGitHubInstallationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ConnectGitHubInstallationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ConnectGitHubInstallationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateApp create app API
*/
func (a *Client) CreateApp(params *CreateAppParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAppOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateAppParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateApp",
		Method:             "POST",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateAppReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateAppOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateAppDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateAppKVSecret create app k v secret API
*/
func (a *Client) CreateAppKVSecret(params *CreateAppKVSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAppKVSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateAppKVSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateAppKVSecret",
		Method:             "POST",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{app_name}/kv",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateAppKVSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateAppKVSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateAppKVSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateAwsSmSyncIntegration create aws sm sync integration API
*/
func (a *Client) CreateAwsSmSyncIntegration(params *CreateAwsSmSyncIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAwsSmSyncIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateAwsSmSyncIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateAwsSmSyncIntegration",
		Method:             "POST",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/aws-sm",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateAwsSmSyncIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateAwsSmSyncIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateAwsSmSyncIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateAzureKvSyncIntegration create azure kv sync integration API
*/
func (a *Client) CreateAzureKvSyncIntegration(params *CreateAzureKvSyncIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAzureKvSyncIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateAzureKvSyncIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateAzureKvSyncIntegration",
		Method:             "POST",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/azure-kv",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateAzureKvSyncIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateAzureKvSyncIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateAzureKvSyncIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateGcpSmSyncIntegration create gcp sm sync integration API
*/
func (a *Client) CreateGcpSmSyncIntegration(params *CreateGcpSmSyncIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateGcpSmSyncIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateGcpSmSyncIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateGcpSmSyncIntegration",
		Method:             "POST",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/gcp-sm",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateGcpSmSyncIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateGcpSmSyncIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateGcpSmSyncIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateGhOrgSyncIntegration create gh org sync integration API
*/
func (a *Client) CreateGhOrgSyncIntegration(params *CreateGhOrgSyncIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateGhOrgSyncIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateGhOrgSyncIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateGhOrgSyncIntegration",
		Method:             "POST",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/gh-org",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateGhOrgSyncIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateGhOrgSyncIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateGhOrgSyncIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateGhRepoSyncIntegration create gh repo sync integration API
*/
func (a *Client) CreateGhRepoSyncIntegration(params *CreateGhRepoSyncIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateGhRepoSyncIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateGhRepoSyncIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateGhRepoSyncIntegration",
		Method:             "POST",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/gh-repo",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateGhRepoSyncIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateGhRepoSyncIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateGhRepoSyncIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateHcpTerraformSyncInstallation create hcp terraform sync installation API
*/
func (a *Client) CreateHcpTerraformSyncInstallation(params *CreateHcpTerraformSyncInstallationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateHcpTerraformSyncInstallationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateHcpTerraformSyncInstallationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateHcpTerraformSyncInstallation",
		Method:             "POST",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/hcp-terraform/installations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateHcpTerraformSyncInstallationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateHcpTerraformSyncInstallationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateHcpTerraformSyncInstallationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateHcpTerraformSyncIntegration create hcp terraform sync integration API
*/
func (a *Client) CreateHcpTerraformSyncIntegration(params *CreateHcpTerraformSyncIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateHcpTerraformSyncIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateHcpTerraformSyncIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateHcpTerraformSyncIntegration",
		Method:             "POST",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/hcp-terraform",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateHcpTerraformSyncIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateHcpTerraformSyncIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateHcpTerraformSyncIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateVercelProjectSyncIntegration create vercel project sync integration API
*/
func (a *Client) CreateVercelProjectSyncIntegration(params *CreateVercelProjectSyncIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateVercelProjectSyncIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateVercelProjectSyncIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateVercelProjectSyncIntegration",
		Method:             "POST",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/vercel-project",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateVercelProjectSyncIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateVercelProjectSyncIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateVercelProjectSyncIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteApp delete app API
*/
func (a *Client) DeleteApp(params *DeleteAppParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteAppOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteAppParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteApp",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteAppReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteAppOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteAppDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteAppSecret delete app secret API
*/
func (a *Client) DeleteAppSecret(params *DeleteAppSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteAppSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteAppSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteAppSecret",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{app_name}/secrets/{secret_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteAppSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteAppSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteAppSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteAppSecretVersion delete app secret version API
*/
func (a *Client) DeleteAppSecretVersion(params *DeleteAppSecretVersionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteAppSecretVersionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteAppSecretVersionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteAppSecretVersion",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{app_name}/secrets/{secret_name}/versions/{version}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteAppSecretVersionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteAppSecretVersionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteAppSecretVersionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteSyncInstallation delete sync installation API
*/
func (a *Client) DeleteSyncInstallation(params *DeleteSyncInstallationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteSyncInstallationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteSyncInstallationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteSyncInstallation",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/installations/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteSyncInstallationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteSyncInstallationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteSyncInstallationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteSyncIntegration delete sync integration API
*/
func (a *Client) DeleteSyncIntegration(params *DeleteSyncIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteSyncIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteSyncIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteSyncIntegration",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/integrations/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteSyncIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteSyncIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteSyncIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ForceSync force sync API
*/
func (a *Client) ForceSync(params *ForceSyncParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ForceSyncOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewForceSyncParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ForceSync",
		Method:             "POST",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/force",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ForceSyncReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ForceSyncOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ForceSyncDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetApp get app API
*/
func (a *Client) GetApp(params *GetAppParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAppOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAppParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetApp",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAppReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAppOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetAppDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetAppSecret get app secret API
*/
func (a *Client) GetAppSecret(params *GetAppSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAppSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAppSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAppSecret",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{app_name}/secrets/{secret_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAppSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAppSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetAppSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetAppSecretVersion get app secret version API
*/
func (a *Client) GetAppSecretVersion(params *GetAppSecretVersionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAppSecretVersionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAppSecretVersionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAppSecretVersion",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{app_name}/secrets/{secret_name}/versions/{version}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAppSecretVersionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAppSecretVersionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetAppSecretVersionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetGitHubEnvironments get git hub environments API
*/
func (a *Client) GetGitHubEnvironments(params *GetGitHubEnvironmentsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetGitHubEnvironmentsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetGitHubEnvironmentsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetGitHubEnvironments",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/github/repositories/{repository}/environments",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetGitHubEnvironmentsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetGitHubEnvironmentsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetGitHubEnvironmentsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetGitHubInstallLinks get git hub install links API
*/
func (a *Client) GetGitHubInstallLinks(params *GetGitHubInstallLinksParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetGitHubInstallLinksOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetGitHubInstallLinksParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetGitHubInstallLinks",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/github/links",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetGitHubInstallLinksReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetGitHubInstallLinksOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetGitHubInstallLinksDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetGitHubRepositories get git hub repositories API
*/
func (a *Client) GetGitHubRepositories(params *GetGitHubRepositoriesParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetGitHubRepositoriesOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetGitHubRepositoriesParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetGitHubRepositories",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/github/repositories",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetGitHubRepositoriesReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetGitHubRepositoriesOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetGitHubRepositoriesDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetSyncInstallation get sync installation API
*/
func (a *Client) GetSyncInstallation(params *GetSyncInstallationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetSyncInstallationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetSyncInstallationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetSyncInstallation",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/installations/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetSyncInstallationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetSyncInstallationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetSyncInstallationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetSyncIntegration get sync integration API
*/
func (a *Client) GetSyncIntegration(params *GetSyncIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetSyncIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetSyncIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetSyncIntegration",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/integrations/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetSyncIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetSyncIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetSyncIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetUsage get usage API
*/
func (a *Client) GetUsage(params *GetUsageParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetUsageOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetUsageParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetUsage",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/usage",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetUsageReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetUsageOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetUsageDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetUsage2 get usage2 API
*/
func (a *Client) GetUsage2(params *GetUsage2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetUsage2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetUsage2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetUsage2",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/usage",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetUsage2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetUsage2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetUsage2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetVercelInstallationLink get vercel installation link API
*/
func (a *Client) GetVercelInstallationLink(params *GetVercelInstallationLinkParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetVercelInstallationLinkOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetVercelInstallationLinkParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetVercelInstallationLink",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/vercel/link",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetVercelInstallationLinkReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetVercelInstallationLinkOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetVercelInstallationLinkDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListAppSecretVersions list app secret versions API
*/
func (a *Client) ListAppSecretVersions(params *ListAppSecretVersionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListAppSecretVersionsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListAppSecretVersionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListAppSecretVersions",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{app_name}/secrets/{secret_name}/versions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListAppSecretVersionsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListAppSecretVersionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListAppSecretVersionsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListAppSecrets list app secrets API
*/
func (a *Client) ListAppSecrets(params *ListAppSecretsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListAppSecretsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListAppSecretsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListAppSecrets",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{app_name}/secrets",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListAppSecretsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListAppSecretsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListAppSecretsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListApps list apps API
*/
func (a *Client) ListApps(params *ListAppsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListAppsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListAppsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListApps",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListAppsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListAppsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListAppsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListGitHubInstallations list git hub installations API
*/
func (a *Client) ListGitHubInstallations(params *ListGitHubInstallationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListGitHubInstallationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListGitHubInstallationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListGitHubInstallations",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/github/installations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListGitHubInstallationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListGitHubInstallationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListGitHubInstallationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListOpenAppSecretVersions list open app secret versions API
*/
func (a *Client) ListOpenAppSecretVersions(params *ListOpenAppSecretVersionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListOpenAppSecretVersionsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListOpenAppSecretVersionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListOpenAppSecretVersions",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{app_name}/open/{secret_name}/versions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListOpenAppSecretVersionsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListOpenAppSecretVersionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListOpenAppSecretVersionsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListSyncInstallations list sync installations API
*/
func (a *Client) ListSyncInstallations(params *ListSyncInstallationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListSyncInstallationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListSyncInstallationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListSyncInstallations",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/installations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListSyncInstallationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListSyncInstallationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListSyncInstallationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListSyncIntegrations list sync integrations API
*/
func (a *Client) ListSyncIntegrations(params *ListSyncIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListSyncIntegrationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListSyncIntegrationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListSyncIntegrations",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/integrations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListSyncIntegrationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListSyncIntegrationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListSyncIntegrationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
OpenAppSecret open app secret API
*/
func (a *Client) OpenAppSecret(params *OpenAppSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OpenAppSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewOpenAppSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "OpenAppSecret",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{app_name}/open/{secret_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &OpenAppSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*OpenAppSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*OpenAppSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
OpenAppSecretVersion open app secret version API
*/
func (a *Client) OpenAppSecretVersion(params *OpenAppSecretVersionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OpenAppSecretVersionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewOpenAppSecretVersionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "OpenAppSecretVersion",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{app_name}/open/{secret_name}/versions/{version}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &OpenAppSecretVersionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*OpenAppSecretVersionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*OpenAppSecretVersionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
OpenAppSecrets open app secrets API
*/
func (a *Client) OpenAppSecrets(params *OpenAppSecretsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OpenAppSecretsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewOpenAppSecretsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "OpenAppSecrets",
		Method:             "GET",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{app_name}/open",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &OpenAppSecretsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*OpenAppSecretsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*OpenAppSecretsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SetTier set tier API
*/
func (a *Client) SetTier(params *SetTierParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SetTierOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSetTierParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "SetTier",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/billing/tier",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &SetTierReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SetTierOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SetTierDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateApp update app API
*/
func (a *Client) UpdateApp(params *UpdateAppParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateAppOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateAppParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateApp",
		Method:             "PATCH",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateAppReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateAppOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateAppDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateSyncInstallation update sync installation API
*/
func (a *Client) UpdateSyncInstallation(params *UpdateSyncInstallationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateSyncInstallationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateSyncInstallationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateSyncInstallation",
		Method:             "PATCH",
		PathPattern:        "/secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/sync/installations/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateSyncInstallationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateSyncInstallationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateSyncInstallationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
