// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-06-13/models"
)

// SetTierReader is a Reader for the SetTier structure.
type SetTierReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SetTierReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSetTierOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSetTierDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSetTierOK creates a SetTierOK with default headers values
func NewSetTierOK() *SetTierOK {
	return &SetTierOK{}
}

/*
SetTierOK describes a response with status code 200, with default header values.

A successful response.
*/
type SetTierOK struct {
	Payload interface{}
}

// IsSuccess returns true when this set tier o k response has a 2xx status code
func (o *SetTierOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this set tier o k response has a 3xx status code
func (o *SetTierOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this set tier o k response has a 4xx status code
func (o *SetTierOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this set tier o k response has a 5xx status code
func (o *SetTierOK) IsServerError() bool {
	return false
}

// IsCode returns true when this set tier o k response a status code equal to that given
func (o *SetTierOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the set tier o k response
func (o *SetTierOK) Code() int {
	return 200
}

func (o *SetTierOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-06-13/organizations/{location.organization_id}/billing/tier][%d] setTierOK %s", 200, payload)
}

func (o *SetTierOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-06-13/organizations/{location.organization_id}/billing/tier][%d] setTierOK %s", 200, payload)
}

func (o *SetTierOK) GetPayload() interface{} {
	return o.Payload
}

func (o *SetTierOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSetTierDefault creates a SetTierDefault with default headers values
func NewSetTierDefault(code int) *SetTierDefault {
	return &SetTierDefault{
		_statusCode: code,
	}
}

/*
SetTierDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type SetTierDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this set tier default response has a 2xx status code
func (o *SetTierDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this set tier default response has a 3xx status code
func (o *SetTierDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this set tier default response has a 4xx status code
func (o *SetTierDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this set tier default response has a 5xx status code
func (o *SetTierDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this set tier default response a status code equal to that given
func (o *SetTierDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the set tier default response
func (o *SetTierDefault) Code() int {
	return o._statusCode
}

func (o *SetTierDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-06-13/organizations/{location.organization_id}/billing/tier][%d] SetTier default %s", o._statusCode, payload)
}

func (o *SetTierDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-06-13/organizations/{location.organization_id}/billing/tier][%d] SetTier default %s", o._statusCode, payload)
}

func (o *SetTierDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *SetTierDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SetTierBody Billing
swagger:model SetTierBody
*/
type SetTierBody struct {

	// location
	Location *SetTierParamsBodyLocation `json:"location,omitempty"`

	// tier
	Tier *models.Secrets20230613Tier `json:"tier,omitempty"`
}

// Validate validates this set tier body
func (o *SetTierBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateTier(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SetTierBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

func (o *SetTierBody) validateTier(formats strfmt.Registry) error {
	if swag.IsZero(o.Tier) { // not required
		return nil
	}

	if o.Tier != nil {
		if err := o.Tier.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "tier")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "tier")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this set tier body based on the context it is used
func (o *SetTierBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateTier(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SetTierBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

func (o *SetTierBody) contextValidateTier(ctx context.Context, formats strfmt.Registry) error {

	if o.Tier != nil {

		if swag.IsZero(o.Tier) { // not required
			return nil
		}

		if err := o.Tier.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "tier")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "tier")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SetTierBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SetTierBody) UnmarshalBinary(b []byte) error {
	var res SetTierBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
SetTierParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model SetTierParamsBodyLocation
*/
type SetTierParamsBodyLocation struct {

	// project_id is the projects id.
	ProjectID string `json:"project_id,omitempty"`

	// region is the region that the resource is located in. It is
	// optional if the object being referenced is a global object.
	Region *models.LocationRegion `json:"region,omitempty"`
}

// Validate validates this set tier params body location
func (o *SetTierParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SetTierParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this set tier params body location based on the context it is used
func (o *SetTierParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SetTierParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *SetTierParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SetTierParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res SetTierParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
