// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewCreateGatewayPoolParams creates a new CreateGatewayPoolParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreateGatewayPoolParams() *CreateGatewayPoolParams {
	return &CreateGatewayPoolParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreateGatewayPoolParamsWithTimeout creates a new CreateGatewayPoolParams object
// with the ability to set a timeout on a request.
func NewCreateGatewayPoolParamsWithTimeout(timeout time.Duration) *CreateGatewayPoolParams {
	return &CreateGatewayPoolParams{
		timeout: timeout,
	}
}

// NewCreateGatewayPoolParamsWithContext creates a new CreateGatewayPoolParams object
// with the ability to set a context for a request.
func NewCreateGatewayPoolParamsWithContext(ctx context.Context) *CreateGatewayPoolParams {
	return &CreateGatewayPoolParams{
		Context: ctx,
	}
}

// NewCreateGatewayPoolParamsWithHTTPClient creates a new CreateGatewayPoolParams object
// with the ability to set a custom HTTPClient for a request.
func NewCreateGatewayPoolParamsWithHTTPClient(client *http.Client) *CreateGatewayPoolParams {
	return &CreateGatewayPoolParams{
		HTTPClient: client,
	}
}

/*
CreateGatewayPoolParams contains all the parameters to send to the API endpoint

	for the create gateway pool operation.

	Typically these are written to a http.Request.
*/
type CreateGatewayPoolParams struct {

	// Body.
	Body *models.SecretServiceCreateGatewayPoolBody

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create gateway pool params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateGatewayPoolParams) WithDefaults() *CreateGatewayPoolParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create gateway pool params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateGatewayPoolParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the create gateway pool params
func (o *CreateGatewayPoolParams) WithTimeout(timeout time.Duration) *CreateGatewayPoolParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create gateway pool params
func (o *CreateGatewayPoolParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create gateway pool params
func (o *CreateGatewayPoolParams) WithContext(ctx context.Context) *CreateGatewayPoolParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create gateway pool params
func (o *CreateGatewayPoolParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create gateway pool params
func (o *CreateGatewayPoolParams) WithHTTPClient(client *http.Client) *CreateGatewayPoolParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create gateway pool params
func (o *CreateGatewayPoolParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the create gateway pool params
func (o *CreateGatewayPoolParams) WithBody(body *models.SecretServiceCreateGatewayPoolBody) *CreateGatewayPoolParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the create gateway pool params
func (o *CreateGatewayPoolParams) SetBody(body *models.SecretServiceCreateGatewayPoolBody) {
	o.Body = body
}

// WithOrganizationID adds the organizationID to the create gateway pool params
func (o *CreateGatewayPoolParams) WithOrganizationID(organizationID string) *CreateGatewayPoolParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the create gateway pool params
func (o *CreateGatewayPoolParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the create gateway pool params
func (o *CreateGatewayPoolParams) WithProjectID(projectID string) *CreateGatewayPoolParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the create gateway pool params
func (o *CreateGatewayPoolParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *CreateGatewayPoolParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
