// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// GetAwsIntegrationReader is a Reader for the GetAwsIntegration structure.
type GetAwsIntegrationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetAwsIntegrationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetAwsIntegrationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetAwsIntegrationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetAwsIntegrationOK creates a GetAwsIntegrationOK with default headers values
func NewGetAwsIntegrationOK() *GetAwsIntegrationOK {
	return &GetAwsIntegrationOK{}
}

/*
GetAwsIntegrationOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetAwsIntegrationOK struct {
	Payload *models.Secrets20231128GetAwsIntegrationResponse
}

// IsSuccess returns true when this get aws integration o k response has a 2xx status code
func (o *GetAwsIntegrationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get aws integration o k response has a 3xx status code
func (o *GetAwsIntegrationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get aws integration o k response has a 4xx status code
func (o *GetAwsIntegrationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get aws integration o k response has a 5xx status code
func (o *GetAwsIntegrationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get aws integration o k response a status code equal to that given
func (o *GetAwsIntegrationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get aws integration o k response
func (o *GetAwsIntegrationOK) Code() int {
	return 200
}

func (o *GetAwsIntegrationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/aws/config/{name}][%d] getAwsIntegrationOK %s", 200, payload)
}

func (o *GetAwsIntegrationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/aws/config/{name}][%d] getAwsIntegrationOK %s", 200, payload)
}

func (o *GetAwsIntegrationOK) GetPayload() *models.Secrets20231128GetAwsIntegrationResponse {
	return o.Payload
}

func (o *GetAwsIntegrationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128GetAwsIntegrationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetAwsIntegrationDefault creates a GetAwsIntegrationDefault with default headers values
func NewGetAwsIntegrationDefault(code int) *GetAwsIntegrationDefault {
	return &GetAwsIntegrationDefault{
		_statusCode: code,
	}
}

/*
GetAwsIntegrationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetAwsIntegrationDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this get aws integration default response has a 2xx status code
func (o *GetAwsIntegrationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get aws integration default response has a 3xx status code
func (o *GetAwsIntegrationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get aws integration default response has a 4xx status code
func (o *GetAwsIntegrationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get aws integration default response has a 5xx status code
func (o *GetAwsIntegrationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get aws integration default response a status code equal to that given
func (o *GetAwsIntegrationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get aws integration default response
func (o *GetAwsIntegrationDefault) Code() int {
	return o._statusCode
}

func (o *GetAwsIntegrationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/aws/config/{name}][%d] GetAwsIntegration default %s", o._statusCode, payload)
}

func (o *GetAwsIntegrationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/aws/config/{name}][%d] GetAwsIntegration default %s", o._statusCode, payload)
}

func (o *GetAwsIntegrationDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *GetAwsIntegrationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
