// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// GetConfluentIntegrationReader is a Reader for the GetConfluentIntegration structure.
type GetConfluentIntegrationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetConfluentIntegrationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetConfluentIntegrationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetConfluentIntegrationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetConfluentIntegrationOK creates a GetConfluentIntegrationOK with default headers values
func NewGetConfluentIntegrationOK() *GetConfluentIntegrationOK {
	return &GetConfluentIntegrationOK{}
}

/*
GetConfluentIntegrationOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetConfluentIntegrationOK struct {
	Payload *models.Secrets20231128GetConfluentIntegrationResponse
}

// IsSuccess returns true when this get confluent integration o k response has a 2xx status code
func (o *GetConfluentIntegrationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get confluent integration o k response has a 3xx status code
func (o *GetConfluentIntegrationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get confluent integration o k response has a 4xx status code
func (o *GetConfluentIntegrationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get confluent integration o k response has a 5xx status code
func (o *GetConfluentIntegrationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get confluent integration o k response a status code equal to that given
func (o *GetConfluentIntegrationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get confluent integration o k response
func (o *GetConfluentIntegrationOK) Code() int {
	return 200
}

func (o *GetConfluentIntegrationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config/{name}][%d] getConfluentIntegrationOK %s", 200, payload)
}

func (o *GetConfluentIntegrationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config/{name}][%d] getConfluentIntegrationOK %s", 200, payload)
}

func (o *GetConfluentIntegrationOK) GetPayload() *models.Secrets20231128GetConfluentIntegrationResponse {
	return o.Payload
}

func (o *GetConfluentIntegrationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128GetConfluentIntegrationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetConfluentIntegrationDefault creates a GetConfluentIntegrationDefault with default headers values
func NewGetConfluentIntegrationDefault(code int) *GetConfluentIntegrationDefault {
	return &GetConfluentIntegrationDefault{
		_statusCode: code,
	}
}

/*
GetConfluentIntegrationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetConfluentIntegrationDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this get confluent integration default response has a 2xx status code
func (o *GetConfluentIntegrationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get confluent integration default response has a 3xx status code
func (o *GetConfluentIntegrationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get confluent integration default response has a 4xx status code
func (o *GetConfluentIntegrationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get confluent integration default response has a 5xx status code
func (o *GetConfluentIntegrationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get confluent integration default response a status code equal to that given
func (o *GetConfluentIntegrationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get confluent integration default response
func (o *GetConfluentIntegrationDefault) Code() int {
	return o._statusCode
}

func (o *GetConfluentIntegrationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config/{name}][%d] GetConfluentIntegration default %s", o._statusCode, payload)
}

func (o *GetConfluentIntegrationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config/{name}][%d] GetConfluentIntegration default %s", o._statusCode, payload)
}

func (o *GetConfluentIntegrationDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *GetConfluentIntegrationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
