// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewOpenAppSecretVersionParams creates a new OpenAppSecretVersionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewOpenAppSecretVersionParams() *OpenAppSecretVersionParams {
	return &OpenAppSecretVersionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewOpenAppSecretVersionParamsWithTimeout creates a new OpenAppSecretVersionParams object
// with the ability to set a timeout on a request.
func NewOpenAppSecretVersionParamsWithTimeout(timeout time.Duration) *OpenAppSecretVersionParams {
	return &OpenAppSecretVersionParams{
		timeout: timeout,
	}
}

// NewOpenAppSecretVersionParamsWithContext creates a new OpenAppSecretVersionParams object
// with the ability to set a context for a request.
func NewOpenAppSecretVersionParamsWithContext(ctx context.Context) *OpenAppSecretVersionParams {
	return &OpenAppSecretVersionParams{
		Context: ctx,
	}
}

// NewOpenAppSecretVersionParamsWithHTTPClient creates a new OpenAppSecretVersionParams object
// with the ability to set a custom HTTPClient for a request.
func NewOpenAppSecretVersionParamsWithHTTPClient(client *http.Client) *OpenAppSecretVersionParams {
	return &OpenAppSecretVersionParams{
		HTTPClient: client,
	}
}

/*
OpenAppSecretVersionParams contains all the parameters to send to the API endpoint

	for the open app secret version operation.

	Typically these are written to a http.Request.
*/
type OpenAppSecretVersionParams struct {

	// AppName.
	AppName string

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	// SecretName.
	SecretName string

	// Version.
	//
	// Format: int64
	Version int64

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the open app secret version params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *OpenAppSecretVersionParams) WithDefaults() *OpenAppSecretVersionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the open app secret version params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *OpenAppSecretVersionParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the open app secret version params
func (o *OpenAppSecretVersionParams) WithTimeout(timeout time.Duration) *OpenAppSecretVersionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the open app secret version params
func (o *OpenAppSecretVersionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the open app secret version params
func (o *OpenAppSecretVersionParams) WithContext(ctx context.Context) *OpenAppSecretVersionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the open app secret version params
func (o *OpenAppSecretVersionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the open app secret version params
func (o *OpenAppSecretVersionParams) WithHTTPClient(client *http.Client) *OpenAppSecretVersionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the open app secret version params
func (o *OpenAppSecretVersionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAppName adds the appName to the open app secret version params
func (o *OpenAppSecretVersionParams) WithAppName(appName string) *OpenAppSecretVersionParams {
	o.SetAppName(appName)
	return o
}

// SetAppName adds the appName to the open app secret version params
func (o *OpenAppSecretVersionParams) SetAppName(appName string) {
	o.AppName = appName
}

// WithOrganizationID adds the organizationID to the open app secret version params
func (o *OpenAppSecretVersionParams) WithOrganizationID(organizationID string) *OpenAppSecretVersionParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the open app secret version params
func (o *OpenAppSecretVersionParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the open app secret version params
func (o *OpenAppSecretVersionParams) WithProjectID(projectID string) *OpenAppSecretVersionParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the open app secret version params
func (o *OpenAppSecretVersionParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WithSecretName adds the secretName to the open app secret version params
func (o *OpenAppSecretVersionParams) WithSecretName(secretName string) *OpenAppSecretVersionParams {
	o.SetSecretName(secretName)
	return o
}

// SetSecretName adds the secretName to the open app secret version params
func (o *OpenAppSecretVersionParams) SetSecretName(secretName string) {
	o.SecretName = secretName
}

// WithVersion adds the version to the open app secret version params
func (o *OpenAppSecretVersionParams) WithVersion(version int64) *OpenAppSecretVersionParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the open app secret version params
func (o *OpenAppSecretVersionParams) SetVersion(version int64) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *OpenAppSecretVersionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param app_name
	if err := r.SetPathParam("app_name", o.AppName); err != nil {
		return err
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	// path param secret_name
	if err := r.SetPathParam("secret_name", o.SecretName); err != nil {
		return err
	}

	// path param version
	if err := r.SetPathParam("version", swag.FormatInt64(o.Version)); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
