// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// PurgeAppAndSecretsReader is a Reader for the PurgeAppAndSecrets structure.
type PurgeAppAndSecretsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PurgeAppAndSecretsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPurgeAppAndSecretsOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPurgeAppAndSecretsDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPurgeAppAndSecretsOK creates a PurgeAppAndSecretsOK with default headers values
func NewPurgeAppAndSecretsOK() *PurgeAppAndSecretsOK {
	return &PurgeAppAndSecretsOK{}
}

/*
PurgeAppAndSecretsOK describes a response with status code 200, with default header values.

A successful response.
*/
type PurgeAppAndSecretsOK struct {
	Payload models.Secrets20231128PurgeAppAndSecretsResponse
}

// IsSuccess returns true when this purge app and secrets o k response has a 2xx status code
func (o *PurgeAppAndSecretsOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this purge app and secrets o k response has a 3xx status code
func (o *PurgeAppAndSecretsOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this purge app and secrets o k response has a 4xx status code
func (o *PurgeAppAndSecretsOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this purge app and secrets o k response has a 5xx status code
func (o *PurgeAppAndSecretsOK) IsServerError() bool {
	return false
}

// IsCode returns true when this purge app and secrets o k response a status code equal to that given
func (o *PurgeAppAndSecretsOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the purge app and secrets o k response
func (o *PurgeAppAndSecretsOK) Code() int {
	return 200
}

func (o *PurgeAppAndSecretsOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{name}:purge][%d] purgeAppAndSecretsOK %s", 200, payload)
}

func (o *PurgeAppAndSecretsOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{name}:purge][%d] purgeAppAndSecretsOK %s", 200, payload)
}

func (o *PurgeAppAndSecretsOK) GetPayload() models.Secrets20231128PurgeAppAndSecretsResponse {
	return o.Payload
}

func (o *PurgeAppAndSecretsOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPurgeAppAndSecretsDefault creates a PurgeAppAndSecretsDefault with default headers values
func NewPurgeAppAndSecretsDefault(code int) *PurgeAppAndSecretsDefault {
	return &PurgeAppAndSecretsDefault{
		_statusCode: code,
	}
}

/*
PurgeAppAndSecretsDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PurgeAppAndSecretsDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this purge app and secrets default response has a 2xx status code
func (o *PurgeAppAndSecretsDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this purge app and secrets default response has a 3xx status code
func (o *PurgeAppAndSecretsDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this purge app and secrets default response has a 4xx status code
func (o *PurgeAppAndSecretsDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this purge app and secrets default response has a 5xx status code
func (o *PurgeAppAndSecretsDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this purge app and secrets default response a status code equal to that given
func (o *PurgeAppAndSecretsDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the purge app and secrets default response
func (o *PurgeAppAndSecretsDefault) Code() int {
	return o._statusCode
}

func (o *PurgeAppAndSecretsDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{name}:purge][%d] PurgeAppAndSecrets default %s", o._statusCode, payload)
}

func (o *PurgeAppAndSecretsDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{name}:purge][%d] PurgeAppAndSecrets default %s", o._statusCode, payload)
}

func (o *PurgeAppAndSecretsDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *PurgeAppAndSecretsDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
