// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// UpdateGatewayPoolReader is a Reader for the UpdateGatewayPool structure.
type UpdateGatewayPoolReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateGatewayPoolReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateGatewayPoolOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUpdateGatewayPoolDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUpdateGatewayPoolOK creates a UpdateGatewayPoolOK with default headers values
func NewUpdateGatewayPoolOK() *UpdateGatewayPoolOK {
	return &UpdateGatewayPoolOK{}
}

/*
UpdateGatewayPoolOK describes a response with status code 200, with default header values.

A successful response.
*/
type UpdateGatewayPoolOK struct {
	Payload *models.Secrets20231128UpdateGatewayPoolResponse
}

// IsSuccess returns true when this update gateway pool o k response has a 2xx status code
func (o *UpdateGatewayPoolOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update gateway pool o k response has a 3xx status code
func (o *UpdateGatewayPoolOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update gateway pool o k response has a 4xx status code
func (o *UpdateGatewayPoolOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update gateway pool o k response has a 5xx status code
func (o *UpdateGatewayPoolOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update gateway pool o k response a status code equal to that given
func (o *UpdateGatewayPoolOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update gateway pool o k response
func (o *UpdateGatewayPoolOK) Code() int {
	return 200
}

func (o *UpdateGatewayPoolOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools/{gateway_pool_name}][%d] updateGatewayPoolOK %s", 200, payload)
}

func (o *UpdateGatewayPoolOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools/{gateway_pool_name}][%d] updateGatewayPoolOK %s", 200, payload)
}

func (o *UpdateGatewayPoolOK) GetPayload() *models.Secrets20231128UpdateGatewayPoolResponse {
	return o.Payload
}

func (o *UpdateGatewayPoolOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128UpdateGatewayPoolResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateGatewayPoolDefault creates a UpdateGatewayPoolDefault with default headers values
func NewUpdateGatewayPoolDefault(code int) *UpdateGatewayPoolDefault {
	return &UpdateGatewayPoolDefault{
		_statusCode: code,
	}
}

/*
UpdateGatewayPoolDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type UpdateGatewayPoolDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this update gateway pool default response has a 2xx status code
func (o *UpdateGatewayPoolDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this update gateway pool default response has a 3xx status code
func (o *UpdateGatewayPoolDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this update gateway pool default response has a 4xx status code
func (o *UpdateGatewayPoolDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this update gateway pool default response has a 5xx status code
func (o *UpdateGatewayPoolDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this update gateway pool default response a status code equal to that given
func (o *UpdateGatewayPoolDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the update gateway pool default response
func (o *UpdateGatewayPoolDefault) Code() int {
	return o._statusCode
}

func (o *UpdateGatewayPoolDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools/{gateway_pool_name}][%d] UpdateGatewayPool default %s", o._statusCode, payload)
}

func (o *UpdateGatewayPoolDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools/{gateway_pool_name}][%d] UpdateGatewayPool default %s", o._statusCode, payload)
}

func (o *UpdateGatewayPoolDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *UpdateGatewayPoolDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
