// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewUpdateIntegrationParams creates a new UpdateIntegrationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewUpdateIntegrationParams() *UpdateIntegrationParams {
	return &UpdateIntegrationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewUpdateIntegrationParamsWithTimeout creates a new UpdateIntegrationParams object
// with the ability to set a timeout on a request.
func NewUpdateIntegrationParamsWithTimeout(timeout time.Duration) *UpdateIntegrationParams {
	return &UpdateIntegrationParams{
		timeout: timeout,
	}
}

// NewUpdateIntegrationParamsWithContext creates a new UpdateIntegrationParams object
// with the ability to set a context for a request.
func NewUpdateIntegrationParamsWithContext(ctx context.Context) *UpdateIntegrationParams {
	return &UpdateIntegrationParams{
		Context: ctx,
	}
}

// NewUpdateIntegrationParamsWithHTTPClient creates a new UpdateIntegrationParams object
// with the ability to set a custom HTTPClient for a request.
func NewUpdateIntegrationParamsWithHTTPClient(client *http.Client) *UpdateIntegrationParams {
	return &UpdateIntegrationParams{
		HTTPClient: client,
	}
}

/*
UpdateIntegrationParams contains all the parameters to send to the API endpoint

	for the update integration operation.

	Typically these are written to a http.Request.
*/
type UpdateIntegrationParams struct {

	// Body.
	Body *models.SecretServiceUpdateIntegrationBody

	// Name.
	Name string

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the update integration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateIntegrationParams) WithDefaults() *UpdateIntegrationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the update integration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *UpdateIntegrationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the update integration params
func (o *UpdateIntegrationParams) WithTimeout(timeout time.Duration) *UpdateIntegrationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the update integration params
func (o *UpdateIntegrationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the update integration params
func (o *UpdateIntegrationParams) WithContext(ctx context.Context) *UpdateIntegrationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the update integration params
func (o *UpdateIntegrationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the update integration params
func (o *UpdateIntegrationParams) WithHTTPClient(client *http.Client) *UpdateIntegrationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the update integration params
func (o *UpdateIntegrationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the update integration params
func (o *UpdateIntegrationParams) WithBody(body *models.SecretServiceUpdateIntegrationBody) *UpdateIntegrationParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the update integration params
func (o *UpdateIntegrationParams) SetBody(body *models.SecretServiceUpdateIntegrationBody) {
	o.Body = body
}

// WithName adds the name to the update integration params
func (o *UpdateIntegrationParams) WithName(name string) *UpdateIntegrationParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the update integration params
func (o *UpdateIntegrationParams) SetName(name string) {
	o.Name = name
}

// WithOrganizationID adds the organizationID to the update integration params
func (o *UpdateIntegrationParams) WithOrganizationID(organizationID string) *UpdateIntegrationParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the update integration params
func (o *UpdateIntegrationParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the update integration params
func (o *UpdateIntegrationParams) WithProjectID(projectID string) *UpdateIntegrationParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the update integration params
func (o *UpdateIntegrationParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *UpdateIntegrationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
