// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointServiceUIGetActionConfigBundleParams creates a new WaypointServiceUIGetActionConfigBundleParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceUIGetActionConfigBundleParams() *WaypointServiceUIGetActionConfigBundleParams {
	return &WaypointServiceUIGetActionConfigBundleParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceUIGetActionConfigBundleParamsWithTimeout creates a new WaypointServiceUIGetActionConfigBundleParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceUIGetActionConfigBundleParamsWithTimeout(timeout time.Duration) *WaypointServiceUIGetActionConfigBundleParams {
	return &WaypointServiceUIGetActionConfigBundleParams{
		timeout: timeout,
	}
}

// NewWaypointServiceUIGetActionConfigBundleParamsWithContext creates a new WaypointServiceUIGetActionConfigBundleParams object
// with the ability to set a context for a request.
func NewWaypointServiceUIGetActionConfigBundleParamsWithContext(ctx context.Context) *WaypointServiceUIGetActionConfigBundleParams {
	return &WaypointServiceUIGetActionConfigBundleParams{
		Context: ctx,
	}
}

// NewWaypointServiceUIGetActionConfigBundleParamsWithHTTPClient creates a new WaypointServiceUIGetActionConfigBundleParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceUIGetActionConfigBundleParamsWithHTTPClient(client *http.Client) *WaypointServiceUIGetActionConfigBundleParams {
	return &WaypointServiceUIGetActionConfigBundleParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceUIGetActionConfigBundleParams contains all the parameters to send to the API endpoint

	for the waypoint service UI get action config bundle operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceUIGetActionConfigBundleParams struct {

	/* ActionID.

	   The id of the action config being requested
	*/
	ActionID string

	/* ActionName.

	   The name of the action being requested (will only be used if id not provided)
	*/
	ActionName *string

	// NamespaceID.
	NamespaceID string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID *string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID *string

	/* NamespaceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	NamespaceLocationRegionProvider *string

	/* NamespaceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	NamespaceLocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service UI get action config bundle params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceUIGetActionConfigBundleParams) WithDefaults() *WaypointServiceUIGetActionConfigBundleParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service UI get action config bundle params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceUIGetActionConfigBundleParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service UI get action config bundle params
func (o *WaypointServiceUIGetActionConfigBundleParams) WithTimeout(timeout time.Duration) *WaypointServiceUIGetActionConfigBundleParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service UI get action config bundle params
func (o *WaypointServiceUIGetActionConfigBundleParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service UI get action config bundle params
func (o *WaypointServiceUIGetActionConfigBundleParams) WithContext(ctx context.Context) *WaypointServiceUIGetActionConfigBundleParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service UI get action config bundle params
func (o *WaypointServiceUIGetActionConfigBundleParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service UI get action config bundle params
func (o *WaypointServiceUIGetActionConfigBundleParams) WithHTTPClient(client *http.Client) *WaypointServiceUIGetActionConfigBundleParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service UI get action config bundle params
func (o *WaypointServiceUIGetActionConfigBundleParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithActionID adds the actionID to the waypoint service UI get action config bundle params
func (o *WaypointServiceUIGetActionConfigBundleParams) WithActionID(actionID string) *WaypointServiceUIGetActionConfigBundleParams {
	o.SetActionID(actionID)
	return o
}

// SetActionID adds the actionId to the waypoint service UI get action config bundle params
func (o *WaypointServiceUIGetActionConfigBundleParams) SetActionID(actionID string) {
	o.ActionID = actionID
}

// WithActionName adds the actionName to the waypoint service UI get action config bundle params
func (o *WaypointServiceUIGetActionConfigBundleParams) WithActionName(actionName *string) *WaypointServiceUIGetActionConfigBundleParams {
	o.SetActionName(actionName)
	return o
}

// SetActionName adds the actionName to the waypoint service UI get action config bundle params
func (o *WaypointServiceUIGetActionConfigBundleParams) SetActionName(actionName *string) {
	o.ActionName = actionName
}

// WithNamespaceID adds the namespaceID to the waypoint service UI get action config bundle params
func (o *WaypointServiceUIGetActionConfigBundleParams) WithNamespaceID(namespaceID string) *WaypointServiceUIGetActionConfigBundleParams {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service UI get action config bundle params
func (o *WaypointServiceUIGetActionConfigBundleParams) SetNamespaceID(namespaceID string) {
	o.NamespaceID = namespaceID
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service UI get action config bundle params
func (o *WaypointServiceUIGetActionConfigBundleParams) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) *WaypointServiceUIGetActionConfigBundleParams {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service UI get action config bundle params
func (o *WaypointServiceUIGetActionConfigBundleParams) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service UI get action config bundle params
func (o *WaypointServiceUIGetActionConfigBundleParams) WithNamespaceLocationProjectID(namespaceLocationProjectID *string) *WaypointServiceUIGetActionConfigBundleParams {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service UI get action config bundle params
func (o *WaypointServiceUIGetActionConfigBundleParams) SetNamespaceLocationProjectID(namespaceLocationProjectID *string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WithNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service UI get action config bundle params
func (o *WaypointServiceUIGetActionConfigBundleParams) WithNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) *WaypointServiceUIGetActionConfigBundleParams {
	o.SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider)
	return o
}

// SetNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service UI get action config bundle params
func (o *WaypointServiceUIGetActionConfigBundleParams) SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) {
	o.NamespaceLocationRegionProvider = namespaceLocationRegionProvider
}

// WithNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service UI get action config bundle params
func (o *WaypointServiceUIGetActionConfigBundleParams) WithNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) *WaypointServiceUIGetActionConfigBundleParams {
	o.SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion)
	return o
}

// SetNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service UI get action config bundle params
func (o *WaypointServiceUIGetActionConfigBundleParams) SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) {
	o.NamespaceLocationRegionRegion = namespaceLocationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceUIGetActionConfigBundleParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param action_id
	if err := r.SetPathParam("action_id", o.ActionID); err != nil {
		return err
	}

	if o.ActionName != nil {

		// query param action_name
		var qrActionName string

		if o.ActionName != nil {
			qrActionName = *o.ActionName
		}
		qActionName := qrActionName
		if qActionName != "" {

			if err := r.SetQueryParam("action_name", qActionName); err != nil {
				return err
			}
		}
	}

	// path param namespace.id
	if err := r.SetPathParam("namespace.id", o.NamespaceID); err != nil {
		return err
	}

	if o.NamespaceLocationOrganizationID != nil {

		// query param namespace.location.organization_id
		var qrNamespaceLocationOrganizationID string

		if o.NamespaceLocationOrganizationID != nil {
			qrNamespaceLocationOrganizationID = *o.NamespaceLocationOrganizationID
		}
		qNamespaceLocationOrganizationID := qrNamespaceLocationOrganizationID
		if qNamespaceLocationOrganizationID != "" {

			if err := r.SetQueryParam("namespace.location.organization_id", qNamespaceLocationOrganizationID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationProjectID != nil {

		// query param namespace.location.project_id
		var qrNamespaceLocationProjectID string

		if o.NamespaceLocationProjectID != nil {
			qrNamespaceLocationProjectID = *o.NamespaceLocationProjectID
		}
		qNamespaceLocationProjectID := qrNamespaceLocationProjectID
		if qNamespaceLocationProjectID != "" {

			if err := r.SetQueryParam("namespace.location.project_id", qNamespaceLocationProjectID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionProvider != nil {

		// query param namespace.location.region.provider
		var qrNamespaceLocationRegionProvider string

		if o.NamespaceLocationRegionProvider != nil {
			qrNamespaceLocationRegionProvider = *o.NamespaceLocationRegionProvider
		}
		qNamespaceLocationRegionProvider := qrNamespaceLocationRegionProvider
		if qNamespaceLocationRegionProvider != "" {

			if err := r.SetQueryParam("namespace.location.region.provider", qNamespaceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionRegion != nil {

		// query param namespace.location.region.region
		var qrNamespaceLocationRegionRegion string

		if o.NamespaceLocationRegionRegion != nil {
			qrNamespaceLocationRegionRegion = *o.NamespaceLocationRegionRegion
		}
		qNamespaceLocationRegionRegion := qrNamespaceLocationRegionRegion
		if qNamespaceLocationRegionRegion != "" {

			if err := r.SetQueryParam("namespace.location.region.region", qNamespaceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
