// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointServiceDestroyApplicationParams creates a new WaypointServiceDestroyApplicationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceDestroyApplicationParams() *WaypointServiceDestroyApplicationParams {
	return &WaypointServiceDestroyApplicationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceDestroyApplicationParamsWithTimeout creates a new WaypointServiceDestroyApplicationParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceDestroyApplicationParamsWithTimeout(timeout time.Duration) *WaypointServiceDestroyApplicationParams {
	return &WaypointServiceDestroyApplicationParams{
		timeout: timeout,
	}
}

// NewWaypointServiceDestroyApplicationParamsWithContext creates a new WaypointServiceDestroyApplicationParams object
// with the ability to set a context for a request.
func NewWaypointServiceDestroyApplicationParamsWithContext(ctx context.Context) *WaypointServiceDestroyApplicationParams {
	return &WaypointServiceDestroyApplicationParams{
		Context: ctx,
	}
}

// NewWaypointServiceDestroyApplicationParamsWithHTTPClient creates a new WaypointServiceDestroyApplicationParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceDestroyApplicationParamsWithHTTPClient(client *http.Client) *WaypointServiceDestroyApplicationParams {
	return &WaypointServiceDestroyApplicationParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceDestroyApplicationParams contains all the parameters to send to the API endpoint

	for the waypoint service destroy application operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceDestroyApplicationParams struct {

	// ApplicationID.
	ApplicationID string

	// ApplicationName.
	ApplicationName *string

	// NamespaceID.
	NamespaceID *string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID string

	/* NamespaceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	NamespaceLocationRegionProvider *string

	/* NamespaceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	NamespaceLocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service destroy application params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceDestroyApplicationParams) WithDefaults() *WaypointServiceDestroyApplicationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service destroy application params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceDestroyApplicationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service destroy application params
func (o *WaypointServiceDestroyApplicationParams) WithTimeout(timeout time.Duration) *WaypointServiceDestroyApplicationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service destroy application params
func (o *WaypointServiceDestroyApplicationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service destroy application params
func (o *WaypointServiceDestroyApplicationParams) WithContext(ctx context.Context) *WaypointServiceDestroyApplicationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service destroy application params
func (o *WaypointServiceDestroyApplicationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service destroy application params
func (o *WaypointServiceDestroyApplicationParams) WithHTTPClient(client *http.Client) *WaypointServiceDestroyApplicationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service destroy application params
func (o *WaypointServiceDestroyApplicationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithApplicationID adds the applicationID to the waypoint service destroy application params
func (o *WaypointServiceDestroyApplicationParams) WithApplicationID(applicationID string) *WaypointServiceDestroyApplicationParams {
	o.SetApplicationID(applicationID)
	return o
}

// SetApplicationID adds the applicationId to the waypoint service destroy application params
func (o *WaypointServiceDestroyApplicationParams) SetApplicationID(applicationID string) {
	o.ApplicationID = applicationID
}

// WithApplicationName adds the applicationName to the waypoint service destroy application params
func (o *WaypointServiceDestroyApplicationParams) WithApplicationName(applicationName *string) *WaypointServiceDestroyApplicationParams {
	o.SetApplicationName(applicationName)
	return o
}

// SetApplicationName adds the applicationName to the waypoint service destroy application params
func (o *WaypointServiceDestroyApplicationParams) SetApplicationName(applicationName *string) {
	o.ApplicationName = applicationName
}

// WithNamespaceID adds the namespaceID to the waypoint service destroy application params
func (o *WaypointServiceDestroyApplicationParams) WithNamespaceID(namespaceID *string) *WaypointServiceDestroyApplicationParams {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service destroy application params
func (o *WaypointServiceDestroyApplicationParams) SetNamespaceID(namespaceID *string) {
	o.NamespaceID = namespaceID
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service destroy application params
func (o *WaypointServiceDestroyApplicationParams) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) *WaypointServiceDestroyApplicationParams {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service destroy application params
func (o *WaypointServiceDestroyApplicationParams) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service destroy application params
func (o *WaypointServiceDestroyApplicationParams) WithNamespaceLocationProjectID(namespaceLocationProjectID string) *WaypointServiceDestroyApplicationParams {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service destroy application params
func (o *WaypointServiceDestroyApplicationParams) SetNamespaceLocationProjectID(namespaceLocationProjectID string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WithNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service destroy application params
func (o *WaypointServiceDestroyApplicationParams) WithNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) *WaypointServiceDestroyApplicationParams {
	o.SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider)
	return o
}

// SetNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service destroy application params
func (o *WaypointServiceDestroyApplicationParams) SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) {
	o.NamespaceLocationRegionProvider = namespaceLocationRegionProvider
}

// WithNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service destroy application params
func (o *WaypointServiceDestroyApplicationParams) WithNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) *WaypointServiceDestroyApplicationParams {
	o.SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion)
	return o
}

// SetNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service destroy application params
func (o *WaypointServiceDestroyApplicationParams) SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) {
	o.NamespaceLocationRegionRegion = namespaceLocationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceDestroyApplicationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param application.id
	if err := r.SetPathParam("application.id", o.ApplicationID); err != nil {
		return err
	}

	if o.ApplicationName != nil {

		// query param application.name
		var qrApplicationName string

		if o.ApplicationName != nil {
			qrApplicationName = *o.ApplicationName
		}
		qApplicationName := qrApplicationName
		if qApplicationName != "" {

			if err := r.SetQueryParam("application.name", qApplicationName); err != nil {
				return err
			}
		}
	}

	if o.NamespaceID != nil {

		// query param namespace.id
		var qrNamespaceID string

		if o.NamespaceID != nil {
			qrNamespaceID = *o.NamespaceID
		}
		qNamespaceID := qrNamespaceID
		if qNamespaceID != "" {

			if err := r.SetQueryParam("namespace.id", qNamespaceID); err != nil {
				return err
			}
		}
	}

	// path param namespace.location.organization_id
	if err := r.SetPathParam("namespace.location.organization_id", o.NamespaceLocationOrganizationID); err != nil {
		return err
	}

	// path param namespace.location.project_id
	if err := r.SetPathParam("namespace.location.project_id", o.NamespaceLocationProjectID); err != nil {
		return err
	}

	if o.NamespaceLocationRegionProvider != nil {

		// query param namespace.location.region.provider
		var qrNamespaceLocationRegionProvider string

		if o.NamespaceLocationRegionProvider != nil {
			qrNamespaceLocationRegionProvider = *o.NamespaceLocationRegionProvider
		}
		qNamespaceLocationRegionProvider := qrNamespaceLocationRegionProvider
		if qNamespaceLocationRegionProvider != "" {

			if err := r.SetQueryParam("namespace.location.region.provider", qNamespaceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionRegion != nil {

		// query param namespace.location.region.region
		var qrNamespaceLocationRegionRegion string

		if o.NamespaceLocationRegionRegion != nil {
			qrNamespaceLocationRegionRegion = *o.NamespaceLocationRegionRegion
		}
		qNamespaceLocationRegionRegion := qrNamespaceLocationRegionRegion
		if qNamespaceLocationRegionRegion != "" {

			if err := r.SetQueryParam("namespace.location.region.region", qNamespaceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
