// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// WaypointServiceListActionRunsByNamespaceReader is a Reader for the WaypointServiceListActionRunsByNamespace structure.
type WaypointServiceListActionRunsByNamespaceReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceListActionRunsByNamespaceReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceListActionRunsByNamespaceOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceListActionRunsByNamespaceDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceListActionRunsByNamespaceOK creates a WaypointServiceListActionRunsByNamespaceOK with default headers values
func NewWaypointServiceListActionRunsByNamespaceOK() *WaypointServiceListActionRunsByNamespaceOK {
	return &WaypointServiceListActionRunsByNamespaceOK{}
}

/*
WaypointServiceListActionRunsByNamespaceOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceListActionRunsByNamespaceOK struct {
	Payload *models.HashicorpCloudWaypointListActionRunsByNamespaceResponse
}

// IsSuccess returns true when this waypoint service list action runs by namespace o k response has a 2xx status code
func (o *WaypointServiceListActionRunsByNamespaceOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service list action runs by namespace o k response has a 3xx status code
func (o *WaypointServiceListActionRunsByNamespaceOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service list action runs by namespace o k response has a 4xx status code
func (o *WaypointServiceListActionRunsByNamespaceOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service list action runs by namespace o k response has a 5xx status code
func (o *WaypointServiceListActionRunsByNamespaceOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service list action runs by namespace o k response a status code equal to that given
func (o *WaypointServiceListActionRunsByNamespaceOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service list action runs by namespace o k response
func (o *WaypointServiceListActionRunsByNamespaceOK) Code() int {
	return 200
}

func (o *WaypointServiceListActionRunsByNamespaceOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/action-runs][%d] waypointServiceListActionRunsByNamespaceOK %s", 200, payload)
}

func (o *WaypointServiceListActionRunsByNamespaceOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/action-runs][%d] waypointServiceListActionRunsByNamespaceOK %s", 200, payload)
}

func (o *WaypointServiceListActionRunsByNamespaceOK) GetPayload() *models.HashicorpCloudWaypointListActionRunsByNamespaceResponse {
	return o.Payload
}

func (o *WaypointServiceListActionRunsByNamespaceOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointListActionRunsByNamespaceResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceListActionRunsByNamespaceDefault creates a WaypointServiceListActionRunsByNamespaceDefault with default headers values
func NewWaypointServiceListActionRunsByNamespaceDefault(code int) *WaypointServiceListActionRunsByNamespaceDefault {
	return &WaypointServiceListActionRunsByNamespaceDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceListActionRunsByNamespaceDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceListActionRunsByNamespaceDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service list action runs by namespace default response has a 2xx status code
func (o *WaypointServiceListActionRunsByNamespaceDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service list action runs by namespace default response has a 3xx status code
func (o *WaypointServiceListActionRunsByNamespaceDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service list action runs by namespace default response has a 4xx status code
func (o *WaypointServiceListActionRunsByNamespaceDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service list action runs by namespace default response has a 5xx status code
func (o *WaypointServiceListActionRunsByNamespaceDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service list action runs by namespace default response a status code equal to that given
func (o *WaypointServiceListActionRunsByNamespaceDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service list action runs by namespace default response
func (o *WaypointServiceListActionRunsByNamespaceDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceListActionRunsByNamespaceDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/action-runs][%d] WaypointService_ListActionRunsByNamespace default %s", o._statusCode, payload)
}

func (o *WaypointServiceListActionRunsByNamespaceDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/action-runs][%d] WaypointService_ListActionRunsByNamespace default %s", o._statusCode, payload)
}

func (o *WaypointServiceListActionRunsByNamespaceDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceListActionRunsByNamespaceDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
