// Code generated by go-swagger; DO NOT EDIT.

package webhook_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-webhook/stable/2023-05-31/models"
)

// WebhookServiceGetWebhookReader is a Reader for the WebhookServiceGetWebhook structure.
type WebhookServiceGetWebhookReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WebhookServiceGetWebhookReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWebhookServiceGetWebhookOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWebhookServiceGetWebhookDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWebhookServiceGetWebhookOK creates a WebhookServiceGetWebhookOK with default headers values
func NewWebhookServiceGetWebhookOK() *WebhookServiceGetWebhookOK {
	return &WebhookServiceGetWebhookOK{}
}

/*
WebhookServiceGetWebhookOK describes a response with status code 200, with default header values.

A successful response.
*/
type WebhookServiceGetWebhookOK struct {
	Payload *models.HashicorpCloudWebhookGetWebhookResponse
}

// IsSuccess returns true when this webhook service get webhook o k response has a 2xx status code
func (o *WebhookServiceGetWebhookOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this webhook service get webhook o k response has a 3xx status code
func (o *WebhookServiceGetWebhookOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this webhook service get webhook o k response has a 4xx status code
func (o *WebhookServiceGetWebhookOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this webhook service get webhook o k response has a 5xx status code
func (o *WebhookServiceGetWebhookOK) IsServerError() bool {
	return false
}

// IsCode returns true when this webhook service get webhook o k response a status code equal to that given
func (o *WebhookServiceGetWebhookOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the webhook service get webhook o k response
func (o *WebhookServiceGetWebhookOK) Code() int {
	return 200
}

func (o *WebhookServiceGetWebhookOK) Error() string {
	return fmt.Sprintf("[GET /2023-05-31/{resource_name}][%d] webhookServiceGetWebhookOK  %+v", 200, o.Payload)
}

func (o *WebhookServiceGetWebhookOK) String() string {
	return fmt.Sprintf("[GET /2023-05-31/{resource_name}][%d] webhookServiceGetWebhookOK  %+v", 200, o.Payload)
}

func (o *WebhookServiceGetWebhookOK) GetPayload() *models.HashicorpCloudWebhookGetWebhookResponse {
	return o.Payload
}

func (o *WebhookServiceGetWebhookOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWebhookGetWebhookResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWebhookServiceGetWebhookDefault creates a WebhookServiceGetWebhookDefault with default headers values
func NewWebhookServiceGetWebhookDefault(code int) *WebhookServiceGetWebhookDefault {
	return &WebhookServiceGetWebhookDefault{
		_statusCode: code,
	}
}

/*
WebhookServiceGetWebhookDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WebhookServiceGetWebhookDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this webhook service get webhook default response has a 2xx status code
func (o *WebhookServiceGetWebhookDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this webhook service get webhook default response has a 3xx status code
func (o *WebhookServiceGetWebhookDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this webhook service get webhook default response has a 4xx status code
func (o *WebhookServiceGetWebhookDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this webhook service get webhook default response has a 5xx status code
func (o *WebhookServiceGetWebhookDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this webhook service get webhook default response a status code equal to that given
func (o *WebhookServiceGetWebhookDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the webhook service get webhook default response
func (o *WebhookServiceGetWebhookDefault) Code() int {
	return o._statusCode
}

func (o *WebhookServiceGetWebhookDefault) Error() string {
	return fmt.Sprintf("[GET /2023-05-31/{resource_name}][%d] WebhookService_GetWebhook default  %+v", o._statusCode, o.Payload)
}

func (o *WebhookServiceGetWebhookDefault) String() string {
	return fmt.Sprintf("[GET /2023-05-31/{resource_name}][%d] WebhookService_GetWebhook default  %+v", o._statusCode, o.Payload)
}

func (o *WebhookServiceGetWebhookDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WebhookServiceGetWebhookDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
