package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// VulnerabilityDataObjectDataSource 数据来源
type VulnerabilityDataObjectDataSource struct {

	// 租户ID
	DomainId *string `json:"domain_id,omitempty"`

	// 项目ID
	ProjectId *string `json:"project_id,omitempty"`

	// 区域ID
	RegionId *string `json:"region_id,omitempty"`

	// 公司名称
	CompanyName *string `json:"company_name,omitempty"`

	// 来源类型
	SourceType *int32 `json:"source_type,omitempty"`

	// 产品名称
	ProductName *string `json:"product_name,omitempty"`

	// 产品特性
	ProductFeature *string `json:"product_feature,omitempty"`
}

func (o VulnerabilityDataObjectDataSource) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "VulnerabilityDataObjectDataSource struct{}"
	}

	return strings.Join([]string{"VulnerabilityDataObjectDataSource", string(data)}, " ")
}
