package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"errors"
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/converter"

	"strings"
)

// GetCustomizeTagsRequest Request Object
type GetCustomizeTagsRequest struct {

	// **参数解释**： 资源类型 **约束限制：** 不涉及 **取值范围：** - cce-cluster：集群  **默认取值：** 不涉及
	ResourceType GetCustomizeTagsRequestResourceType `json:"resource_type"`
}

func (o GetCustomizeTagsRequest) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "GetCustomizeTagsRequest struct{}"
	}

	return strings.Join([]string{"GetCustomizeTagsRequest", string(data)}, " ")
}

type GetCustomizeTagsRequestResourceType struct {
	value string
}

type GetCustomizeTagsRequestResourceTypeEnum struct {
	CCE_CLUSTER GetCustomizeTagsRequestResourceType
}

func GetGetCustomizeTagsRequestResourceTypeEnum() GetCustomizeTagsRequestResourceTypeEnum {
	return GetCustomizeTagsRequestResourceTypeEnum{
		CCE_CLUSTER: GetCustomizeTagsRequestResourceType{
			value: "cce-cluster",
		},
	}
}

func (c GetCustomizeTagsRequestResourceType) Value() string {
	return c.value
}

func (c GetCustomizeTagsRequestResourceType) MarshalJSON() ([]byte, error) {
	return utils.Marshal(c.value)
}

func (c *GetCustomizeTagsRequestResourceType) UnmarshalJSON(b []byte) error {
	myConverter := converter.StringConverterFactory("string")
	if myConverter == nil {
		return errors.New("unsupported StringConverter type: string")
	}

	interf, err := myConverter.CovertStringToInterface(strings.Trim(string(b[:]), "\""))
	if err != nil {
		return err
	}

	if val, ok := interf.(string); ok {
		c.value = val
		return nil
	} else {
		return errors.New("convert enum data to string error")
	}
}
