package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// EventForensicInfoMalwareForensic **参数解释**： 恶意软件取证信息 **取值范围**： 不涉及
type EventForensicInfoMalwareForensic struct {

	// **参数解释**： 恶意软件家族 **取值范围**： 不涉及
	MalwareFamily *string `json:"malware_family,omitempty"`

	// **参数解释**： 恶意软件名称 **取值范围**： 不涉及
	MalwareName *string `json:"malware_name,omitempty"`

	// **参数解释**： 恶意软件类型 **取值范围**： 不涉及
	MalwareType *string `json:"malware_type,omitempty"`

	// **参数解释**： 置信度 **取值范围**： 不涉及
	Confidence *int32 `json:"confidence,omitempty"`
}

func (o EventForensicInfoMalwareForensic) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "EventForensicInfoMalwareForensic struct{}"
	}

	return strings.Join([]string{"EventForensicInfoMalwareForensic", string(data)}, " ")
}
