package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// ShowResourceResponse Response Object
type ShowResourceResponse struct {

	// 错误码
	Code *string `json:"code,omitempty"`

	// 错误信息
	Message *string `json:"message,omitempty"`

	Data           *ResourceDetail `json:"data,omitempty"`
	HttpStatusCode int             `json:"-"`
}

func (o ShowResourceResponse) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "ShowResourceResponse struct{}"
	}

	return strings.Join([]string{"ShowResourceResponse", string(data)}, " ")
}
