package model

import (
	"github.com/huaweicloud/huaweicloud-sdk-go-v3/core/utils"

	"strings"
)

// VulnerabilityDataObjectVulnerability 漏洞详细信息
type VulnerabilityDataObjectVulnerability struct {

	// 漏洞ID
	Id *string `json:"id,omitempty"`

	// 漏洞类型编号
	Type *int32 `json:"type,omitempty"`

	// 漏洞链接
	Url *string `json:"url,omitempty"`

	// 漏洞状态
	Status *int32 `json:"status,omitempty"`

	// 漏洞等级
	Level *string `json:"level,omitempty"`

	// 漏洞产生原因
	Reason *string `json:"reason,omitempty"`

	// 漏洞解决方案
	Solution *string `json:"solution,omitempty"`

	// 修复紧急程度
	RepairSeverity *int32 `json:"repair_severity,omitempty"`

	// 相关漏洞
	Related *[]interface{} `json:"related,omitempty"`

	// 漏洞标签
	Tags *[]string `json:"tags,omitempty"`
}

func (o VulnerabilityDataObjectVulnerability) String() string {
	data, err := utils.Marshal(o)
	if err != nil {
		return "VulnerabilityDataObjectVulnerability struct{}"
	}

	return strings.Join([]string{"VulnerabilityDataObjectVulnerability", string(data)}, " ")
}
