// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NodeSelectorTerm A null or empty node selector term matches no objects. The requirements of them are ANDed. The TopologySelectorTerm type implements a subset of the NodeSelectorTerm.
//
// swagger:model nodeSelectorTerm
type NodeSelectorTerm struct {

	// A list of node selector requirements by node's labels.
	MatchExpressions []*NodeSelectorTermMatchExpressionsItems0 `json:"matchExpressions"`

	// A list of node selector requirements by node's fields.
	MatchFields []*NodeSelectorTermMatchFieldsItems0 `json:"matchFields"`
}

// Validate validates this node selector term
func (m *NodeSelectorTerm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMatchExpressions(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMatchFields(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeSelectorTerm) validateMatchExpressions(formats strfmt.Registry) error {
	if swag.IsZero(m.MatchExpressions) { // not required
		return nil
	}

	for i := 0; i < len(m.MatchExpressions); i++ {
		if swag.IsZero(m.MatchExpressions[i]) { // not required
			continue
		}

		if m.MatchExpressions[i] != nil {
			if err := m.MatchExpressions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("matchExpressions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("matchExpressions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeSelectorTerm) validateMatchFields(formats strfmt.Registry) error {
	if swag.IsZero(m.MatchFields) { // not required
		return nil
	}

	for i := 0; i < len(m.MatchFields); i++ {
		if swag.IsZero(m.MatchFields[i]) { // not required
			continue
		}

		if m.MatchFields[i] != nil {
			if err := m.MatchFields[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("matchFields" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("matchFields" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this node selector term based on the context it is used
func (m *NodeSelectorTerm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMatchExpressions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMatchFields(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeSelectorTerm) contextValidateMatchExpressions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.MatchExpressions); i++ {

		if m.MatchExpressions[i] != nil {
			if err := m.MatchExpressions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("matchExpressions" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("matchExpressions" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *NodeSelectorTerm) contextValidateMatchFields(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.MatchFields); i++ {

		if m.MatchFields[i] != nil {
			if err := m.MatchFields[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("matchFields" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("matchFields" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeSelectorTerm) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeSelectorTerm) UnmarshalBinary(b []byte) error {
	var res NodeSelectorTerm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeSelectorTermMatchExpressionsItems0 A node selector requirement is a selector that contains values, a key, and an operator that relates the key and values.
//
// swagger:model NodeSelectorTermMatchExpressionsItems0
type NodeSelectorTermMatchExpressionsItems0 struct {

	// The label key that the selector applies to.
	// Required: true
	Key *string `json:"key"`

	// Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
	// Required: true
	Operator *string `json:"operator"`

	// An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.
	Values []string `json:"values"`
}

// Validate validates this node selector term match expressions items0
func (m *NodeSelectorTermMatchExpressionsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateKey(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOperator(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeSelectorTermMatchExpressionsItems0) validateKey(formats strfmt.Registry) error {

	if err := validate.Required("key", "body", m.Key); err != nil {
		return err
	}

	return nil
}

func (m *NodeSelectorTermMatchExpressionsItems0) validateOperator(formats strfmt.Registry) error {

	if err := validate.Required("operator", "body", m.Operator); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this node selector term match expressions items0 based on context it is used
func (m *NodeSelectorTermMatchExpressionsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NodeSelectorTermMatchExpressionsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeSelectorTermMatchExpressionsItems0) UnmarshalBinary(b []byte) error {
	var res NodeSelectorTermMatchExpressionsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}

// NodeSelectorTermMatchFieldsItems0 A node selector requirement is a selector that contains values, a key, and an operator that relates the key and values.
//
// swagger:model NodeSelectorTermMatchFieldsItems0
type NodeSelectorTermMatchFieldsItems0 struct {

	// The label key that the selector applies to.
	// Required: true
	Key *string `json:"key"`

	// Represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists, DoesNotExist. Gt, and Lt.
	// Required: true
	Operator *string `json:"operator"`

	// An array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. If the operator is Gt or Lt, the values array must have a single element, which will be interpreted as an integer. This array is replaced during a strategic merge patch.
	Values []string `json:"values"`
}

// Validate validates this node selector term match fields items0
func (m *NodeSelectorTermMatchFieldsItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateKey(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOperator(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeSelectorTermMatchFieldsItems0) validateKey(formats strfmt.Registry) error {

	if err := validate.Required("key", "body", m.Key); err != nil {
		return err
	}

	return nil
}

func (m *NodeSelectorTermMatchFieldsItems0) validateOperator(formats strfmt.Registry) error {

	if err := validate.Required("operator", "body", m.Operator); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this node selector term match fields items0 based on context it is used
func (m *NodeSelectorTermMatchFieldsItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (m *NodeSelectorTermMatchFieldsItems0) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeSelectorTermMatchFieldsItems0) UnmarshalBinary(b []byte) error {
	var res NodeSelectorTermMatchFieldsItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
