// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// TLSConfiguration tls configuration
//
// swagger:model tlsConfiguration
type TLSConfiguration struct {

	// minio c as certificates
	MinioCAsCertificates []string `json:"minioCAsCertificates"`

	// minio client certificates
	MinioClientCertificates []*KeyPairConfiguration `json:"minioClientCertificates"`

	// minio server certificates
	MinioServerCertificates []*KeyPairConfiguration `json:"minioServerCertificates"`
}

// Validate validates this tls configuration
func (m *TLSConfiguration) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateMinioClientCertificates(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateMinioServerCertificates(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TLSConfiguration) validateMinioClientCertificates(formats strfmt.Registry) error {
	if swag.IsZero(m.MinioClientCertificates) { // not required
		return nil
	}

	for i := 0; i < len(m.MinioClientCertificates); i++ {
		if swag.IsZero(m.MinioClientCertificates[i]) { // not required
			continue
		}

		if m.MinioClientCertificates[i] != nil {
			if err := m.MinioClientCertificates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("minioClientCertificates" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("minioClientCertificates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *TLSConfiguration) validateMinioServerCertificates(formats strfmt.Registry) error {
	if swag.IsZero(m.MinioServerCertificates) { // not required
		return nil
	}

	for i := 0; i < len(m.MinioServerCertificates); i++ {
		if swag.IsZero(m.MinioServerCertificates[i]) { // not required
			continue
		}

		if m.MinioServerCertificates[i] != nil {
			if err := m.MinioServerCertificates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("minioServerCertificates" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("minioServerCertificates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this tls configuration based on the context it is used
func (m *TLSConfiguration) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateMinioClientCertificates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateMinioServerCertificates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TLSConfiguration) contextValidateMinioClientCertificates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.MinioClientCertificates); i++ {

		if m.MinioClientCertificates[i] != nil {
			if err := m.MinioClientCertificates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("minioClientCertificates" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("minioClientCertificates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *TLSConfiguration) contextValidateMinioServerCertificates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.MinioServerCertificates); i++ {

		if m.MinioServerCertificates[i] != nil {
			if err := m.MinioServerCertificates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("minioServerCertificates" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("minioServerCertificates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *TLSConfiguration) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TLSConfiguration) UnmarshalBinary(b []byte) error {
	var res TLSConfiguration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
