// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const AddAccessRuleIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={"min-icon"}
    viewBox="0 0 256 256"
    {...props}
  >
    <g
      id="Add_Access_Rule"
      data-name="Add Access Rule"
      clipPath="url(#clip-Add_Access_Rule)"
    >
      <rect width="256" height="256" fill="#fff" />
      <g id="Add_Access_Rule_Icon" data-name="Add Access Rule Icon">
        <g id="Grupo_2406" data-name="Grupo 2406" transform="translate(18)">
          <g id="Grupo_2405" data-name="Grupo 2405">
            <path
              id="Trazado_7142"
              data-name="Trazado 7142"
              d="M104.258,94.5a8.671,8.671,0,1,0,12.263,0,8.672,8.672,0,0,0-12.263,0"
              fill="#4ccb92"
            />
            <path
              id="Trazado_7143"
              data-name="Trazado 7143"
              d="M220.846,46.255a15.346,15.346,0,0,0-15.422-14.381h-.01l-2.217.017c-18.3,0-53.371-3.671-82.6-28.236A15.2,15.2,0,0,0,110.742,0a15.03,15.03,0,0,0-9.748,3.6C71.681,28.225,36.7,31.9,18.452,31.9l-2.764-.028A15.124,15.124,0,0,0,.665,46.358C-1.156,93.424-.821,159.771,23,192.41c22.161,30.467,65.486,55.314,78.912,61.614a20.721,20.721,0,0,0,17.7-.015c14.415-6.8,56.684-31.109,78.885-61.582,23.832-32.654,24.168-99,22.347-146.172m-92.069,94.893,0,25.363H118.635v12.845h10.146v11H118.635V203.2h10.148v1.651l-18.394,18.394L92,204.849l.007-63.7a38.469,38.469,0,0,1-9.2-6.8A39.158,39.158,0,0,1,116.79,68.09a38.019,38.019,0,0,1,23.45,13.338,39.022,39.022,0,0,1-11.463,59.72"
              fill="#4ccb92"
            />
          </g>
        </g>
        <rect
          id="Rectángulo_1019"
          data-name="Rectángulo 1019"
          width="256"
          height="256"
          fill="none"
        />
      </g>
    </g>
  </svg>
);

export default AddAccessRuleIcon;
