// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const AllBucketsIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g data-name="All Buckets" clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <path
        data-name="Uni\xF3n 45"
        d="M78.373 256c-7.594 0-14.115-5.922-15.51-14.087-1.619-9.346-4.373-25.445-7.537-43.926l-.01-.074C49.08 161.58 41.277 116.057 37.57 94.461a18.4 18.4 0 0 1 3.377-14.209 15.24 15.24 0 0 1 12.148-6.235h150.137a15.259 15.259 0 0 1 12.154 6.235 18.358 18.358 0 0 1 3.369 14.209l-7.5 43.7-.035.171-10.184 59.448-.049.265-7.523 43.872c-1.408 8.165-7.914 14.087-15.516 14.087Zm-3.418-16.57a3.582 3.582 0 0 0 3.418 3.1h99.58a3.582 3.582 0 0 0 3.424-3.105l6.178-36.084H68.768c2.591 15.142 4.818 28.093 6.187 36.086Zm-8.5-49.559h123.42l7.928-46.218H58.539c2.609 15.186 5.363 31.301 7.916 46.216ZM50.416 88.858a4.087 4.087 0 0 0-.738 3.12c1.572 9.228 3.922 22.825 6.549 38.2h143.895l6.531-38.2a4.055 4.055 0 0 0-.74-3.115 3.354 3.354 0 0 0-2.68-1.381H53.086a3.359 3.359 0 0 0-2.67 1.374Zm170.543 29.158v-1.083l.014-.088 1.615-9.414h6.221a1.281 1.281 0 0 0 1.188-1.151c.074-.412.148-.847.227-1.3l.029-.162c.043-.25.088-.5.131-.764.02-.127.045-.255.064-.382s.049-.279.074-.421c.063-.377.131-.759.2-1.156l.031-.171c.043-.25.088-.509.131-.769l.045-.245c.029-.191.063-.382.1-.578l.67-3.884c.855-4.981 1.486-8.66 2.055-12h-10.43l-.244-.656a25.505 25.505 0 0 0-3.664-6.74c-.4-.529-.822-1.043-1.252-1.523l-1.49-1.666h18.9l.158-.936c.172-1.009.35-2.038.525-3.061.367-2.15.734-4.3 1.076-6.289.1-.568.2-1.137.293-1.709.117-.676.23-1.362.348-2.042l.5-2.915c.59-3.443 1.2-6.989 1.8-10.5h-86.41l3.648 21.243h-10.016l-4.379-25.588-4.787-27.855a12.711 12.711 0 0 1 2.342-9.826 10.739 10.739 0 0 1 8.545-4.379h95.705a10.723 10.723 0 0 1 8.541 4.379 12.715 12.715 0 0 1 2.342 9.826c-.414 2.419-.9 5.241-1.463 8.5l-.943 5.535c-.143.8-.279 1.622-.426 2.454l-.189 1.117q-.381 2.249-.793 4.619l-.982 5.73c-1.7 9.958-3.67 21.39-5.25 30.579l-.68 3.962-.578 3.375v.039l-.713 4.183c-.1.563-.2 1.131-.3 1.758-.1.593-.211 1.229-.334 1.944l-.4 2.312-1 5.843c-.787 4.585-1.531 8.915-2.072 12.049-.975 5.682-5.547 9.806-10.875 9.806ZM148.313 11.072a1.612 1.612 0 0 0-.289 1.225l4.025 23.516h90.041a16029.61 16029.61 0 0 1 3.365-19.617l.088-.485.582-3.414a1.611 1.611 0 0 0-.289-1.225 1.174 1.174 0 0 0-.9-.475h-95.715a1.154 1.154 0 0 0-.909.473ZM34.038 118.016h-6.852c-5.326 0-9.9-4.125-10.877-9.811-.539-3.13-1.281-7.459-2.07-12.049l-.287-1.7-.711-4.144-.4-2.307c-.127-.72-.234-1.361-.336-1.954l-.3-1.749-.717-4.183v-.039l-1.252-7.293c-1.58-9.2-3.545-20.65-5.252-30.623L4 36.434q-.407-2.381-.8-4.639l-.186-1.1c-.143-.833-.283-1.651-.426-2.449l-.953-5.588C1.078 19.41.598 16.609.182 14.204a12.722 12.722 0 0 1 2.342-9.826 10.729 10.729 0 0 1 8.543-4.379h95.705a10.744 10.744 0 0 1 8.545 4.379 12.719 12.719 0 0 1 2.342 9.826l-4.809 27.968-4.359 25.475H98.479l.2-1.171 3.449-20.072H15.716c.607 3.512 1.213 7.058 1.8 10.5l.5 2.915c.117.681.23 1.366.346 2.047l.293 1.7c.344 1.993.711 4.153 1.082 6.313.17 1.019.348 2.038.52 3.037l.16.936h18.9l-1.49 1.666c-.432.48-.854.994-1.252 1.523a25.567 25.567 0 0 0-3.666 6.74l-.244.656H22.237c.566 3.34 1.2 7.019 2.053 12l.672 3.884c.035.2.068.387.1.583l.045.24c.043.26.088.52.131.769l.006.01.023.162c.07.4.137.779.2 1.151l.074.426c.025.142.045.255.064.382.043.254.088.509.131.754l.029.171c.078.451.152.886.227 1.3a1.284 1.284 0 0 0 1.188 1.151h6.223l1.629 9.5v1.083ZM10.155 11.077a1.609 1.609 0 0 0-.285 1.22l.672 3.9c1.027 5.966 2.318 13.509 3.365 19.617h90.041l4.025-23.516a1.612 1.612 0 0 0-.289-1.225 1.159 1.159 0 0 0-.908-.475H11.061a1.185 1.185 0 0 0-.907.477Z"
      />
      <path data-name="Rect\xE1ngulo 927" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default AllBucketsIcon;
