// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const CalendarIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <g data-name="Calendar-icn">
        <path
          data-name="Trazado 412"
          d="M65.175 146.527h24.651c3.4 0 6.162-3.188 6.162-7.115s-2.762-7.115-6.162-7.115H65.175c-3.4 0-6.164 3.188-6.164 7.115s2.758 7.115 6.164 7.115Z"
        />
        <path
          data-name="Trazado 413"
          d="M118.028 146.527h24.651c3.4 0 6.162-3.188 6.162-7.115s-2.76-7.115-6.162-7.115h-24.651c-3.4 0-6.162 3.188-6.162 7.115s2.762 7.115 6.162 7.115Z"
        />
        <path
          data-name="Trazado 414"
          d="M166.344 146.527h24.651c3.4 0 6.162-3.188 6.162-7.115s-2.762-7.115-6.162-7.115h-24.651c-3.4 0-6.165 3.188-6.165 7.115s2.762 7.115 6.165 7.115Z"
        />
        <path
          data-name="Trazado 415"
          d="M65.175 178.762h24.651c3.4 0 6.162-3.188 6.162-7.115s-2.762-7.115-6.162-7.115H65.175c-3.4 0-6.164 3.188-6.164 7.115s2.758 7.115 6.164 7.115Z"
        />
        <path
          data-name="Trazado 416"
          d="M118.028 178.762h24.651c3.4 0 6.162-3.188 6.162-7.115s-2.76-7.115-6.162-7.115h-24.651c-3.4 0-6.162 3.188-6.162 7.115s2.762 7.115 6.162 7.115Z"
        />
        <path
          data-name="Trazado 417"
          d="M166.344 178.762h24.651c3.4 0 6.162-3.188 6.162-7.115s-2.762-7.115-6.162-7.115h-24.651c-3.4 0-6.165 3.188-6.165 7.115s2.762 7.115 6.165 7.115Z"
        />
        <path
          data-name="Trazado 418"
          d="M65.175 210.997h24.651c3.4 0 6.162-3.187 6.162-7.115s-2.762-7.115-6.162-7.115H65.175c-3.4 0-6.164 3.188-6.164 7.115s2.758 7.115 6.164 7.115Z"
        />
        <path
          data-name="Trazado 419"
          d="M118.028 210.997h24.651c3.4 0 6.162-3.187 6.162-7.115s-2.76-7.115-6.162-7.115h-24.651c-3.4 0-6.162 3.188-6.162 7.115s2.762 7.115 6.162 7.115Z"
        />
        <path
          data-name="Trazado 420"
          d="M166.344 210.997h24.651c3.4 0 6.162-3.187 6.162-7.115s-2.762-7.115-6.162-7.115h-24.651c-3.4 0-6.165 3.188-6.165 7.115s2.762 7.115 6.165 7.115Z"
        />
        <path
          data-name="Trazado 421"
          d="M215.81 30.376h-15.951V10.455a10.661 10.661 0 0 0-10.6-10.661 10.66 10.66 0 0 0-10.595 10.661v19.921h-40.089V10.455a10.661 10.661 0 0 0-10.6-10.661 10.66 10.66 0 0 0-10.595 10.661v19.921H77.291V10.455a10.661 10.661 0 0 0-10.6-10.661 10.66 10.66 0 0 0-10.595 10.661v19.921h-15.08a23.369 23.369 0 0 0-23.295 23.44v178.332a23.367 23.367 0 0 0 23.295 23.44h174.782a23.367 23.367 0 0 0 23.295-23.44V53.816a23.367 23.367 0 0 0-23.283-23.44Zm-3.051 198.641a.062.062 0 0 1-.062.062H44.14a.062.062 0 0 1-.064-.062V114.344h168.683Z"
        />
      </g>
      <path data-name="Rect\xE1ngulo 862" fill="none" d="M0 0h256v255.794H0z" />
    </g>
  </svg>
);

export default CalendarIcon;
