// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const ChangePasswordIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={"min-icon"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="clip-path">
        <rect
          id="Rectángulo_1033"
          data-name="Rectángulo 1033"
          width="234.584"
          height="256"
          fill="#4ccb92"
        />
      </clipPath>
      <clipPath id="clip-Change_User_Password">
        <rect width="256" height="256" />
      </clipPath>
    </defs>
    <g
      id="Change_User_Password"
      data-name="Change User Password"
      clipPath="url(#clip-Change_User_Password)"
    >
      <rect width="256" height="256" fill="#fff" />
      <g id="Change_User_Password_Icon" data-name="Change User Password Icon">
        <g id="Grupo_2422" data-name="Grupo 2422" transform="translate(11)">
          <g id="Grupo_2421" data-name="Grupo 2421">
            <path
              id="Trazado_7174"
              data-name="Trazado 7174"
              d="M89.039,144.5h.048a66.549,66.549,0,0,0,26.922-5.683,68.721,68.721,0,0,0,22.01-15.464,71.754,71.754,0,0,0,14.829-22.881,73.555,73.555,0,0,0,5.44-27.984C158.291,32.8,127.233.5,89.04.5h0C50.868.5,19.816,32.794,19.816,72.49S50.868,144.5,89.039,144.5"
              transform="translate(1.369 0.035)"
              fill="#4ccb92"
            />
            <path
              id="Trazado_7175"
              data-name="Trazado 7175"
              d="M89.039,144.5h.048a66.549,66.549,0,0,0,26.922-5.683,68.721,68.721,0,0,0,22.01-15.464,71.754,71.754,0,0,0,14.829-22.881,73.555,73.555,0,0,0,5.44-27.984C158.291,32.8,127.233.5,89.04.5h0C50.868.5,19.816,32.794,19.816,72.49S50.868,144.5,89.039,144.5Z"
              transform="translate(1.369 0.035)"
              fill="#4ccb92"
            />
            <path
              id="Trazado_7176"
              data-name="Trazado 7176"
              d="M169.875,117.967A64.121,64.121,0,0,0,112.7,153.043c-1.421-.4-2.848-.78-4.286-1.119a94.31,94.31,0,0,0-21.382-2.511v.005c-1.748,0-3.424.045-4.982.135A99.34,99.34,0,0,0,8.563,189.619c-.386.516-.763,1.056-1.228,1.749l-.107.15c-.1.141-.213.3-.311.456L6.89,192a37.722,37.722,0,0,0-2.66,37.365,31.837,31.837,0,0,0,28.644,17.951H141.951a31.362,31.362,0,0,0,13.027-2.828,64.139,64.139,0,1,0,14.9-126.523m.382,114.817a50.676,50.676,0,1,1,50.676-50.676,50.676,50.676,0,0,1-50.676,50.676"
              transform="translate(0.035 8.148)"
              fill="#4ccb92"
            />
            <path
              id="Trazado_7177"
              data-name="Trazado 7177"
              d="M169.875,117.967A64.121,64.121,0,0,0,112.7,153.043c-1.421-.4-2.848-.78-4.286-1.119a94.31,94.31,0,0,0-21.382-2.511v.005c-1.748,0-3.424.045-4.982.135A99.34,99.34,0,0,0,8.563,189.619c-.386.516-.763,1.056-1.228,1.749l-.107.15c-.1.141-.213.3-.311.456L6.89,192a37.722,37.722,0,0,0-2.66,37.365,31.837,31.837,0,0,0,28.644,17.951H141.951a31.362,31.362,0,0,0,13.027-2.828,64.139,64.139,0,1,0,14.9-126.523Zm.382,114.817a50.676,50.676,0,1,1,50.676-50.676A50.676,50.676,0,0,1,170.256,232.784Z"
              transform="translate(0.035 8.148)"
              fill="#4ccb92"
            />
            <path
              id="Trazado_7178"
              data-name="Trazado 7178"
              d="M175.869,148.182a20.812,20.812,0,0,0-20.809,20.813,20.593,20.593,0,0,0,.9,6.036l-24.028,24.024v13.874h13.875L169.833,188.9a20.816,20.816,0,0,0,26.849-18.2,20.283,20.283,0,0,0-3.813-13.874,20.814,20.814,0,0,0-17-8.642m2.311,23.125a4.625,4.625,0,1,1,4.626-4.624,4.625,4.625,0,0,1-4.626,4.624"
              transform="translate(9.112 10.235)"
              fill="#4ccb92"
            />
            <path
              id="Trazado_7179"
              data-name="Trazado 7179"
              d="M175.869,148.182a20.812,20.812,0,0,0-20.809,20.813,20.593,20.593,0,0,0,.9,6.036l-24.028,24.024v13.874h13.875L169.833,188.9a20.816,20.816,0,0,0,26.849-18.2,20.283,20.283,0,0,0-3.813-13.874A20.814,20.814,0,0,0,175.869,148.182Zm2.311,23.125a4.625,4.625,0,1,1,4.626-4.624A4.625,4.625,0,0,1,178.181,171.307Z"
              transform="translate(9.112 10.235)"
              fill="#4ccb92"
            />
          </g>
        </g>
        <rect
          id="Rectángulo_1034"
          data-name="Rectángulo 1034"
          width="256"
          height="256"
          fill="none"
        />
      </g>
    </g>
  </svg>
);

export default ChangePasswordIcon;
