// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const CreateNewPathIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={"min-icon"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="clip-path">
        <rect
          id="Rectángulo_1026"
          data-name="Rectángulo 1026"
          width="255.576"
          height="182.735"
          fill="none"
        />
      </clipPath>
      <clipPath id="clip-Create_New_Path">
        <rect width="256" height="256" />
      </clipPath>
    </defs>
    <g
      id="Create_New_Path"
      data-name="Create New Path"
      clipPath="url(#clip-Create_New_Path)"
    >
      <rect width="256" height="256" fill="#fff" />
      <g id="Create_New_Path_Icon" data-name="Create New Path Icon">
        <g
          id="Grupo_2415"
          data-name="Grupo 2415"
          transform="translate(0.424 26.642)"
        >
          <g id="Grupo_2414" data-name="Grupo 2414">
            <path
              id="Trazado_7162"
              data-name="Trazado 7162"
              d="M21.8,141.76c-11.745,0-21.8,9.96-21.8,21.517a22.187,22.187,0,0,0,21.8,21.8c11.557,0,21.517-10.054,21.517-21.8A21.949,21.949,0,0,0,21.8,141.76"
              transform="translate(0 -59.036)"
              fill="#4ccb92"
            />
            <path
              id="Trazado_7163"
              data-name="Trazado 7163"
              d="M21.8,235.632c-11.745,0-21.8,9.96-21.8,21.517a22.187,22.187,0,0,0,21.8,21.8c11.557,0,21.517-10.054,21.517-21.8A21.949,21.949,0,0,0,21.8,235.632"
              transform="translate(0 -98.13)"
              fill="#4ccb92"
            />
            <path
              id="Trazado_7164"
              data-name="Trazado 7164"
              d="M200.314,0H187.871A11.54,11.54,0,0,0,177.5,6.479L99.6,166.135a11.54,11.54,0,0,0,10.371,16.6h12.443a11.54,11.54,0,0,0,10.371-6.479L210.684,16.6A11.539,11.539,0,0,0,200.314,0"
              transform="translate(-40.986)"
              fill="#4ccb92"
            />
            <path
              id="Trazado_7165"
              data-name="Trazado 7165"
              d="M294.178,82.251c-1.23,0-2.445.061-3.652.149l32.106-65.8A11.539,11.539,0,0,0,312.262,0H299.819a11.539,11.539,0,0,0-10.371,6.479l-77.9,159.656a11.539,11.539,0,0,0,10.37,16.6h12.443a11.54,11.54,0,0,0,10.371-6.479l8.685-17.8a49,49,0,1,0,40.762-76.205m.292,87.721a38.717,38.717,0,1,1,38.717-38.717,38.717,38.717,0,0,1-38.717,38.717"
              transform="translate(-87.607)"
              fill="#4ccb92"
            />
            <path
              id="Trazado_7166"
              data-name="Trazado 7166"
              d="M347.565,193.708H335.42v12.145H323.275V218H335.42v12.145h12.145V218h12.145V205.853H347.565Z"
              transform="translate(-134.629 -80.67)"
              fill="#4ccb92"
            />
          </g>
        </g>
        <rect
          id="Rectángulo_1027"
          data-name="Rectángulo 1027"
          width="256"
          height="256"
          fill="none"
        />
      </g>
    </g>
  </svg>
);

export default CreateNewPathIcon;
