// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const DriveFormatErrorsIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={"min-icon"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="clip-path">
        <rect
          id="Rectángulo_1025"
          data-name="Rectángulo 1025"
          width="256"
          height="236.235"
          fill="none"
        />
      </clipPath>
      <clipPath id="clip-Drive_Format_Errors">
        <rect width="256" height="256" />
      </clipPath>
    </defs>
    <g
      id="Drive_Format_Errors"
      data-name="Drive Format Errors"
      clipPath="url(#clip-Drive_Format_Errors)"
    >
      <rect width="256" height="256" fill="#fff" />
      <g id="Drive_Format_Errors-Icon" data-name="Drive Format Errors-Icon">
        <rect
          id="Rectángulo_1004"
          data-name="Rectángulo 1004"
          width="256"
          height="256"
          fill="none"
        />
        <g
          id="Grupo_2413"
          data-name="Grupo 2413"
          transform="translate(0.637 9.778)"
        >
          <g
            id="Grupo_2412"
            data-name="Grupo 2412"
            transform="translate(0 0.001)"
          >
            <path
              id="Trazado_7156"
              data-name="Trazado 7156"
              d="M97.03,336.139a9.708,9.708,0,1,1,.007,0"
              transform="translate(-47.133 -168.561)"
              fill="#c83b51"
            />
            <path
              id="Trazado_7157"
              data-name="Trazado 7157"
              d="M139.7,336.054a6.907,6.907,0,1,0-7.923-5.713,6.907,6.907,0,0,0,7.923,5.713"
              transform="translate(-68.864 -168.564)"
              fill="#c83b51"
            />
            <path
              id="Trazado_7158"
              data-name="Trazado 7158"
              d="M256.009,77.663A47.444,47.444,0,0,0,198.24,31.346a118.111,118.111,0,1,0,38,86.785c0-.642-.014-1.281-.024-1.921a47.383,47.383,0,0,0,19.793-38.546M43.519,118.312,67.309,58.88A5.7,5.7,0,0,1,72.6,55.3h91.06a5.686,5.686,0,0,1,2.687.677,47.446,47.446,0,0,0,26.623,66.516,5.7,5.7,0,0,1-5.312,3.641H48.809a5.7,5.7,0,0,1-5.29-7.818M201.9,175.033a5.937,5.937,0,0,1-5.936,5.936H40.294a5.936,5.936,0,0,1-5.936-5.936V146.671a5.936,5.936,0,0,1,5.936-5.936H195.96a5.937,5.937,0,0,1,5.936,5.936Zm6.94-59.871A37.494,37.494,0,1,1,246.33,77.668a37.494,37.494,0,0,1-37.494,37.494"
              transform="translate(-0.009 -0.013)"
              fill="#c83b51"
            />
            <path
              id="Trazado_7159"
              data-name="Trazado 7159"
              d="M282.274,335.577h-80.98a4.182,4.182,0,0,1-4.169-4.169v-5.956a4.182,4.182,0,0,1,4.169-4.169h80.98a4.182,4.182,0,0,1,4.169,4.169v5.956a4.182,4.182,0,0,1-4.169,4.169"
              transform="translate(-103.088 -168.017)"
              fill="#c83b51"
            />
            <path
              id="Trazado_7160"
              data-name="Trazado 7160"
              d="M435.958,142.765l1.282-30.209h-12.4l1.282,30.209Z"
              transform="translate(-222.172 -58.862)"
              fill="#c83b51"
            />
            <path
              id="Trazado_7161"
              data-name="Trazado 7161"
              d="M430.2,183.9a6.94,6.94,0,1,0,6.887,6.993v-.106A7.067,7.067,0,0,0,430.2,183.9"
              transform="translate(-221.316 -96.17)"
              fill="#c83b51"
            />
          </g>
        </g>
      </g>
    </g>
  </svg>
);

export default DriveFormatErrorsIcon;
