// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const FileCodeIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <path
        data-name="Trazado 432"
        d="M235.994 77.198c.387-15.753.958-32.242-.5-47.941-1.093-11.756-6.192-21.735-17.831-25.916a42.553 42.553 0 0 0-5.016-1.447c-6.55-1.478-13.432-1.6-20.09-1.8-11.727-.343-23.45.366-35.176.314-23.494-.1-46.986.322-70.479.414q-4.228.018-8.456.017H36.24A17.26 17.26 0 0 0 19 18.08v220.679A17.26 17.26 0 0 0 36.24 256h182.54a17.26 17.26 0 0 0 17.24-17.241V128.816c-.002-17.183-.452-34.459-.026-51.618ZM215.068 223.19a14.888 14.888 0 0 1-14.889 14.888H51.81a14.888 14.888 0 0 1-14.888-14.888V33.662A14.888 14.888 0 0 1 51.81 18.774h99.549v25.459a37.8 37.8 0 0 0 37.756 37.759h25.953Zm0-157.656h-25.952a21.32 21.32 0 0 1-21.3-21.3V18.775h32.358a14.888 14.888 0 0 1 14.894 14.888Z"
      />
      <path
        data-name="Trazado 433"
        d="M142.243 86.687a7.664 7.664 0 0 0-5.873.748 7.728 7.728 0 0 0-3.655 4.732l-27.607 102.662a7.778 7.778 0 0 0 5.464 9.515 7.487 7.487 0 0 0 2.023.276 7.828 7.828 0 0 0 3.885-1.039 7.641 7.641 0 0 0 3.63-4.712l27.606-102.662a7.781 7.781 0 0 0-5.474-9.52Z"
      />
      <path
        data-name="Trazado 434"
        d="m76.404 145.413 20.711-20.71a7.78 7.78 0 0 0 0-10.99 7.8 7.8 0 0 0-10.985 0l-.224.278c-.44.642-3.849 3.92-7.146 7.09-17.4 16.732-21.453 21.528-21.139 24-.5 3.044 4.393 8.7 20.83 24.509 3.423 3.292 6.963 6.7 7.418 7.429l.213.275a7.338 7.338 0 0 0 5.313 2.366 7.168 7.168 0 0 0 1.8-.232 8.626 8.626 0 0 0 6-5.946 7.17 7.17 0 0 0-2.045-7.1Z"
      />
      <path
        data-name="Trazado 435"
        d="M159.273 111.622a8.619 8.619 0 0 0-5.932 6 7.187 7.187 0 0 0 2.121 7.1l20.906 20.685-20.9 20.9a7.5 7.5 0 0 0-1.677 8.451 7.574 7.574 0 0 0 6.88 4.852 2.3 2.3 0 0 0 .538.062c2.979 0 8.8-5.225 24.1-21.218 3.243-3.389 6.6-6.894 7.281-7.345l.282-.224a7.734 7.734 0 0 0 2.277-5.524 7.746 7.746 0 0 0-2.308-5.523l-26.444-26.164a7.188 7.188 0 0 0-7.124-2.047Z"
      />
      <path data-name="Rect\xE1ngulo 899" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default FileCodeIcon;
