// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const LDAPIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    {...props}
    className={`min-icon`}
    fill={"currentcolor"}
    xmlns="http://www.w3.org/2000/svg"
    viewBox="0 0 550 350"
  >
    <metadata id="metadata4860"></metadata>
    <defs id="defs4858">
      <clipPath clipPathUnits="userSpaceOnUse" id="clipPath4882">
        <path d="M 117,49 H 262 V 240 H 117 Z" id="path4880" />
      </clipPath>
    </defs>
    <g id="g4862" transform="matrix(1.3333333,0,0,1.3333333,0,-199.99999)">
      <g id="g5617" transform="translate(-0.61796941,-4.3257855)">
        <path
          transform="matrix(0.75000002,0,0,0.75000002,0,150)"
          id="path5017"
          d="M 106.41289,293.96864 C 70.04539,293.67237 34.537909,293.3758 27.507375,293.3096 L 14.724586,293.18923 75.914974,188.8693 C 109.56969,131.49334 137.22453,84.543112 137.37018,84.535469 c 0.40034,-0.02101 84.5549,148.389841 84.58064,149.162261 0.0123,0.3688 -7.67138,14.22492 -17.07481,30.79139 l -17.09715,30.12084 -7.62163,-0.0513 c -4.19189,-0.0282 -37.37684,-0.29372 -73.74434,-0.58999 z"
        />
        <path
          transform="matrix(0.75000002,0,0,0.75000002,0,150)"
          id="path5019"
          d="m 231.52153,216.29609 c -1.78448,-2.78648 -56.30805,-96.43861 -56.30805,-96.71724 0,-0.37557 46.76629,-81.164403 47.28254,-81.680648 0.25121,-0.251211 54.29846,91.624688 56.25895,95.635598 0.25352,0.51868 -5.58291,11.22113 -22.82887,41.86203 -12.74321,22.64086 -23.30746,41.32406 -23.4761,41.51823 -0.16865,0.19416 -0.58646,-0.0839 -0.92847,-0.61797 z"
        />
        <path
          transform="matrix(0.75000002,0,0,0.75000002,0,150)"
          id="path5021"
          d="m 188.85669,326.46569 c 0.087,-0.23351 27.87116,-49.19652 61.74268,-108.80668 l 61.58456,-108.38212 1.96842,3.38056 c 1.08262,1.85931 29.54627,50.37713 63.25256,107.81739 l 61.28415,104.43682 -1.65524,0.0945 c -0.91038,0.052 -43.18277,0.37347 -93.93866,0.71445 -50.75588,0.34098 -106.25889,0.74364 -123.34,0.89481 -21.25746,0.18813 -31.00669,0.14089 -30.89847,-0.14972 z"
        />
        <path
          transform="matrix(0.75000002,0,0,0.75000002,0,150)"
          id="path5023"
          d="m 441.01638,296.1697 c -2.28982,-3.78012 -75.22429,-129.17288 -75.5565,-129.90068 -0.32741,-0.71732 3.48432,-7.56149 23.74743,-42.63989 13.27559,-22.98198 24.27489,-41.830698 24.44289,-41.886033 0.2706,-0.08913 126.68565,215.010973 126.46114,215.178533 -0.0495,0.0369 -22.18445,0.18265 -49.18885,0.32387 l -49.09891,0.25674 z"
        />
      </g>
      <path
        d=""
        id="path5031"
        transform="matrix(0.75000002,0,0,0.75000002,0,150)"
      />
      <path
        d=""
        id="path5033"
        transform="matrix(0.75000002,0,0,0.75000002,0,150)"
      />
      <path
        d=""
        id="path5039"
        transform="matrix(0.75000002,0,0,0.75000002,0,150)"
      />
      <path
        d=""
        id="path5041"
        transform="matrix(0.75000002,0,0,0.75000002,0,150)"
      />
    </g>
  </svg>
);

export default LDAPIcon;
