// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const ServiceAccountIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <path
        data-name="Trazado 463"
        d="M32.291 232.53a32.336 32.336 0 0 1-32.289-32.3V76.935a32.33 32.33 0 0 1 32.289-32.3 8.837 8.837 0 0 1 8.832 8.822 8.845 8.845 0 0 1-8.832 8.831 14.663 14.663 0 0 0-14.648 14.648v123.295a14.661 14.661 0 0 0 14.648 14.64h191.4a14.66 14.66 0 0 0 14.641-14.64V76.936a14.661 14.661 0 0 0-14.641-14.648h-54.07a8.845 8.845 0 0 1-8.832-8.831 8.762 8.762 0 0 1 2.586-6.236 8.735 8.735 0 0 1 6.246-2.586h54.07a32.345 32.345 0 0 1 32.313 32.3V200.23a32.351 32.351 0 0 1-32.312 32.3Zm140.445-33.006a3.078 3.078 0 0 1-3.082-3.07V179.02a3.08 3.08 0 0 1 3.082-3.08h47.18a3.077 3.077 0 0 1 3.07 3.08v17.434a3.075 3.075 0 0 1-3.07 3.07Zm-113.141 0a22.643 22.643 0 0 1-20.648-12.767 26.835 26.835 0 0 1 1.891-26.579l.02-.019c.094-.143.2-.285.3-.428.273-.409.559-.827.871-1.245a70.651 70.651 0 0 1 52.277-28.5 62.967 62.967 0 0 1 3.543-.095 67.043 67.043 0 0 1 15.211 1.777 71.594 71.594 0 0 1 14.734 5.219 71.248 71.248 0 0 1 26.73 22.149 27.371 27.371 0 0 1 2.672 27.53 22.363 22.363 0 0 1-20.629 12.956Zm-3.719-30.372v.01l-.047.058c-.191.256-.371.5-.531.741v.028l-.258.371a8.365 8.365 0 0 0-.715 8.261 5.526 5.526 0 0 0 5.27 3.1h76.969a6.062 6.062 0 0 0 3.156-.761 4.988 4.988 0 0 0 1.949-2.243 8.485 8.485 0 0 0 .715-4.524 9.18 9.18 0 0 0-1.7-4.468 54.088 54.088 0 0 0-42.969-22.007c-.93 0-1.75.019-2.508.066h-.012a53.055 53.055 0 0 0-39.318 21.368Zm116.859-5.01a3.08 3.08 0 0 1-3.082-3.079v-17.425a3.08 3.08 0 0 1 3.082-3.08h47.18a3.077 3.077 0 0 1 3.07 3.08v17.425a3.077 3.077 0 0 1-3.07 3.079Zm-.59-38.7a2.5 2.5 0 0 1-2.492-2.5V82.066a2.5 2.5 0 0 1 2.492-2.5h48.348a2.5 2.5 0 0 1 2.492 2.5v40.876a2.5 2.5 0 0 1-2.492 2.5ZM50.981 74.213c0-28.233 22.09-51.209 49.242-51.209s49.258 22.976 49.258 51.209a52.579 52.579 0 0 1-3.867 19.906 51.257 51.257 0 0 1-10.551 16.274 49.07 49.07 0 0 1-15.656 11 47.257 47.257 0 0 1-19.184 4.041c-27.151 0-49.241-22.976-49.241-51.22Zm17.977 0c0 18.033 14.031 32.711 31.266 32.711 17.262 0 31.3-14.678 31.3-32.711s-14.039-32.7-31.3-32.7c-17.234 0-31.265 14.668-31.265 32.701Z"
      />
      <path data-name="Rect\xE1ngulo 883" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default ServiceAccountIcon;
