// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const RegisterMenuIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 12 12"
    {...props}
  >
    <defs>
      <clipPath id="clip-path-reg-menu-icon">
        <rect
          id="Rectángulo_1593"
          data-name="Rectángulo 1593"
          width="12"
          height="12"
        />
      </clipPath>
    </defs>
    <g
      id="Grupo_2469"
      data-name="Grupo 2469"
      clipPath="url(#clip-path-reg-menu-icon)"
    >
      <path
        id="Trazado_7117"
        data-name="Trazado 7117"
        d="M11.4,7.564a1.848,1.848,0,0,0,.6-1.17,1.848,1.848,0,0,0-.6-1.17,1.866,1.866,0,0,1-.377-.532,2.022,2.022,0,0,1,0-.693,1.858,1.858,0,0,0-.17-1.282,1.7,1.7,0,0,0-1.126-.567A1.8,1.8,0,0,1,9.1,1.94a1.924,1.924,0,0,1-.374-.546A1.775,1.775,0,0,0,7.854.442,1.649,1.649,0,0,0,6.646.671,1.833,1.833,0,0,1,6,.89,1.833,1.833,0,0,1,5.354.671,1.649,1.649,0,0,0,4.146.442a1.78,1.78,0,0,0-.872.952,1.926,1.926,0,0,1-.377.549,1.806,1.806,0,0,1-.625.209,1.7,1.7,0,0,0-1.126.567A1.865,1.865,0,0,0,.977,3.994a2.053,2.053,0,0,1,0,.693A1.915,1.915,0,0,1,.6,5.223,1.844,1.844,0,0,0,0,6.394a1.843,1.843,0,0,0,.6,1.17,1.932,1.932,0,0,1,.377.53,2.061,2.061,0,0,1,0,.694,1.865,1.865,0,0,0,.169,1.282,1.7,1.7,0,0,0,1.126.567,1.806,1.806,0,0,1,.625.209,1.925,1.925,0,0,1,.377.548,1.775,1.775,0,0,0,.872.948,1.649,1.649,0,0,0,1.208-.228A1.831,1.831,0,0,1,6,11.894a1.832,1.832,0,0,1,.646.219,2.244,2.244,0,0,0,.908.281.929.929,0,0,0,.3-.049,1.773,1.773,0,0,0,.872-.951,1.934,1.934,0,0,1,.377-.548,1.8,1.8,0,0,1,.625-.209,1.7,1.7,0,0,0,1.126-.567,1.853,1.853,0,0,0,.169-1.284,2.051,2.051,0,0,1,0-.693,1.881,1.881,0,0,1,.377-.529M5.367,8.69,3.051,6.269l.821-.855L5.367,6.973,8.128,4.1l.821.858Z"
        transform="translate(0 -0.394)"
      />
    </g>
  </svg>
);

export default RegisterMenuIcon;
