// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const StandardLightLogo = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    viewBox="0 0 87.892 10.08"
    className={"min-icon"}
    fill={"currentcolor"}
    {...props}
  >
    <path
      d="M8.421-8.869A6,6,0,0,0,4.893-9.94c-2.065,0-3.745,1.057-3.745,2.947,0,1.673,1.288,2.422,2.905,2.618l.91.112c1.526.189,2.345.623,2.345,1.533,0,1.106-1.148,1.7-2.611,1.7A5.235,5.235,0,0,1,1.505-2.114l-.672.98A6.35,6.35,0,0,0,4.7.14C6.818.14,8.589-.882,8.589-2.835c0-1.729-1.421-2.4-3.08-2.6l-.861-.1c-1.47-.182-2.219-.637-2.219-1.526,0-1.057,1.022-1.7,2.457-1.7a5.128,5.128,0,0,1,2.905.9Zm10.6-.931H11.109v1.169h3.346V0h1.232V-8.631h3.339Zm6.692,0H24.185L20.2,0h1.281l1.071-2.674h4.753L28.385,0h1.323Zm-.784,1.218,1.9,4.739H23.023ZM41.02-9.8H39.788v7.693l-5.929-7.7H32.746V0h1.232l.007-7.693,5.922,7.7H41.02Zm4.193,0V0h3.738c3.164,0,5.194-1.918,5.194-4.9s-2.03-4.9-5.194-4.9Zm3.738,1.169c2.569,0,3.9,1.5,3.9,3.731s-1.33,3.731-3.9,3.731H46.445V-8.631ZM61.866-9.8H60.333L56.35,0h1.281L58.7-2.674h4.753L64.533,0h1.323Zm-.784,1.218,1.9,4.739H59.171ZM68.894-9.8V0h1.232V-4.228h1.148L74.641,0h1.526L72.716-4.228h.077c2.1,0,3.423-1.092,3.423-2.793C76.216-8.806,75-9.8,72.786-9.8Zm3.864,1.155c1.421,0,2.177.539,2.177,1.624S74.2-5.348,72.758-5.348H70.126v-3.3ZM79.793-9.8V0h3.738c3.164,0,5.194-1.918,5.194-4.9s-2.03-4.9-5.194-4.9Zm3.738,1.169c2.569,0,3.9,1.5,3.9,3.731s-1.33,3.731-3.9,3.731H81.025V-8.631Z"
      transform="translate(-0.833 9.94)"
      fill="#aec1d9"
    />
  </svg>
);

export default StandardLightLogo;
