// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const UsersIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <g data-name="users-icn">
        <path
          data-name="Trazado 331"
          d="M128.212 142.371c39.3 0 71.279-31.6 71.279-70.444S167.512 1.483 128.212 1.483s-71.268 31.6-71.268 70.444 31.977 70.444 71.268 70.444Zm0-121.306c28.383 0 51.463 22.818 51.463 50.862s-23.08 50.862-51.463 50.862-51.445-22.816-51.445-50.862 23.066-50.862 51.445-50.862Z"
        />
        <path
          data-name="Trazado 331 - Contorno"
          d="M128.212 143.853c-40.124 0-72.768-32.266-72.768-71.927S88.088-.001 128.212-.001s72.779 32.266 72.779 71.927-32.649 71.927-72.779 71.927Zm0-140.888c-38.47 0-69.768 30.936-69.768 68.961s31.3 68.961 69.768 68.961 69.779-30.936 69.779-68.961-31.303-68.961-69.779-68.961Zm0 121.305c-29.194 0-52.945-23.481-52.945-52.344s23.751-52.345 52.945-52.345 52.963 23.482 52.963 52.345-23.76 52.345-52.963 52.345Zm0-101.724c-27.54 0-49.945 22.152-49.945 49.38s22.405 49.379 49.945 49.379 49.963-22.151 49.963-49.379-22.414-49.379-49.963-49.379Z"
        />
        <path
          data-name="Trazado 332"
          d="M215.129 199.095a108.6 108.6 0 0 0-41.184-32.37 111.377 111.377 0 0 0-51.553-10.081c-31.26 1.575-62.109 17.524-80.5 41.632-.613.8-1.213 1.624-1.8 2.439a35.274 35.274 0 0 0-2.746 36.518c5.68 10.824 16.691 17.287 29.441 17.287h122.867c12.885 0 23.883-6.551 29.4-17.513a36.09 36.09 0 0 0-3.925-37.912Zm-13.812 29.2c-1.529 3.029-4.8 6.648-11.662 6.648H66.783c-7.25 0-10.545-4.215-11.861-6.724a15.692 15.692 0 0 1 1.361-16.225c.473-.647.938-1.29 1.43-1.93 14.951-19.6 40.129-32.58 65.688-33.869 1.408-.068 2.816-.1 4.213-.1 27.5 0 55.287 13.376 71.729 34.828a16.785 16.785 0 0 1 1.974 17.372Z"
        />
        <path
          data-name="Trazado 332 - Contorno"
          d="M127.643 155.028a110.952 110.952 0 0 1 23.833 2.624 115.878 115.878 0 0 1 23.1 7.726 110.137 110.137 0 0 1 41.751 32.821 37.565 37.565 0 0 1 4.07 39.465 33.137 33.137 0 0 1-5.348 7.707 32.51 32.51 0 0 1-7.156 5.772 33.964 33.964 0 0 1-8.59 3.612 37.261 37.261 0 0 1-9.646 1.247H66.783a37.248 37.248 0 0 1-9.57-1.23 34.36 34.36 0 0 1-8.568-3.563 33.1 33.1 0 0 1-7.191-5.693 33.672 33.672 0 0 1-5.443-7.6 36.758 36.758 0 0 1 2.851-38.053l.009-.012c.576-.794 1.2-1.642 1.825-2.466 18.644-24.445 49.918-40.623 81.618-42.22 1.769-.092 3.556-.137 5.329-.137Zm62.011 98.007c12.31 0 22.8-6.24 28.053-16.691a34.607 34.607 0 0 0-3.773-36.354 107.135 107.135 0 0 0-40.617-31.92 112.854 112.854 0 0 0-22.492-7.524 107.908 107.908 0 0 0-23.179-2.552c-1.722 0-3.463.044-5.174.13-30.837 1.554-61.251 17.281-79.375 41.044-.608.8-1.214 1.627-1.779 2.4a33.793 33.793 0 0 0-2.638 34.976c5.418 10.324 15.926 16.488 28.11 16.488Zm-62.037-78.43a93.962 93.962 0 0 1 40.673 9.521 90.119 90.119 0 0 1 32.251 25.895 18.687 18.687 0 0 1 3.738 9.3 17.136 17.136 0 0 1-1.619 9.631 13.216 13.216 0 0 1-4.318 5.019 15.031 15.031 0 0 1-8.688 2.453H66.783a15.1 15.1 0 0 1-9.041-2.706 13.981 13.981 0 0 1-4.152-4.818 17.173 17.173 0 0 1 1.466-17.761l.01-.015.19-.261c.4-.554.822-1.127 1.258-1.694 15.213-19.942 40.813-33.145 66.808-34.457a84.647 84.647 0 0 1 4.295-.108Zm62.037 58.85a12.08 12.08 0 0 0 6.975-1.922 10.268 10.268 0 0 0 3.345-3.9 14.2 14.2 0 0 0 1.324-7.982 15.738 15.738 0 0 0-3.147-7.833 87.116 87.116 0 0 0-31.182-25.025 90.916 90.916 0 0 0-39.353-9.218c-1.373 0-2.765.034-4.14.1a89.517 89.517 0 0 0-36.2 9.9 84.252 84.252 0 0 0-28.362 23.379v.005c-.414.538-.8 1.072-1.216 1.637l-.186.254a14.21 14.21 0 0 0-1.252 14.683 10.988 10.988 0 0 0 3.259 3.788 12.148 12.148 0 0 0 7.271 2.136Z"
        />
      </g>
      <path data-name="Rect\xE1ngulo 885" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default UsersIcon;
