// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2023 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package logging

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/runtime"

	"github.com/minio/console/models"
)

// LogSearchOKCode is the HTTP code returned for type LogSearchOK
const LogSearchOKCode int = 200

/*
LogSearchOK A successful response.

swagger:response logSearchOK
*/
type LogSearchOK struct {

	/*
	  In: Body
	*/
	Payload *models.LogSearchResponse `json:"body,omitempty"`
}

// NewLogSearchOK creates LogSearchOK with default headers values
func NewLogSearchOK() *LogSearchOK {

	return &LogSearchOK{}
}

// WithPayload adds the payload to the log search o k response
func (o *LogSearchOK) WithPayload(payload *models.LogSearchResponse) *LogSearchOK {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the log search o k response
func (o *LogSearchOK) SetPayload(payload *models.LogSearchResponse) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *LogSearchOK) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(200)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}

/*
LogSearchDefault Generic error response.

swagger:response logSearchDefault
*/
type LogSearchDefault struct {
	_statusCode int

	/*
	  In: Body
	*/
	Payload *models.APIError `json:"body,omitempty"`
}

// NewLogSearchDefault creates LogSearchDefault with default headers values
func NewLogSearchDefault(code int) *LogSearchDefault {
	if code <= 0 {
		code = 500
	}

	return &LogSearchDefault{
		_statusCode: code,
	}
}

// WithStatusCode adds the status to the log search default response
func (o *LogSearchDefault) WithStatusCode(code int) *LogSearchDefault {
	o._statusCode = code
	return o
}

// SetStatusCode sets the status to the log search default response
func (o *LogSearchDefault) SetStatusCode(code int) {
	o._statusCode = code
}

// WithPayload adds the payload to the log search default response
func (o *LogSearchDefault) WithPayload(payload *models.APIError) *LogSearchDefault {
	o.Payload = payload
	return o
}

// SetPayload sets the payload to the log search default response
func (o *LogSearchDefault) SetPayload(payload *models.APIError) {
	o.Payload = payload
}

// WriteResponse to the client
func (o *LogSearchDefault) WriteResponse(rw http.ResponseWriter, producer runtime.Producer) {

	rw.WriteHeader(o._statusCode)
	if o.Payload != nil {
		payload := o.Payload
		if err := producer.Produce(rw, payload); err != nil {
			panic(err) // let the recovery middleware deal with this
		}
	}
}
