// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// TenantLogs tenant logs
//
// swagger:model tenantLogs
type TenantLogs struct {

	// annotations
	Annotations []*Annotation `json:"annotations"`

	// db annotations
	DbAnnotations []*Annotation `json:"dbAnnotations"`

	// db image
	DbImage string `json:"dbImage,omitempty"`

	// db init image
	DbInitImage string `json:"dbInitImage,omitempty"`

	// db labels
	DbLabels []*Label `json:"dbLabels"`

	// db node selector
	DbNodeSelector []*NodeSelector `json:"dbNodeSelector"`

	// db security context
	DbSecurityContext *SecurityContext `json:"dbSecurityContext,omitempty"`

	// db service account name
	DbServiceAccountName string `json:"dbServiceAccountName,omitempty"`

	// disabled
	Disabled bool `json:"disabled,omitempty"`

	// disk capacity g b
	DiskCapacityGB string `json:"diskCapacityGB,omitempty"`

	// image
	Image string `json:"image,omitempty"`

	// labels
	Labels []*Label `json:"labels"`

	// log CPU request
	LogCPURequest string `json:"logCPURequest,omitempty"`

	// log d b CPU request
	LogDBCPURequest string `json:"logDBCPURequest,omitempty"`

	// log d b mem request
	LogDBMemRequest string `json:"logDBMemRequest,omitempty"`

	// log mem request
	LogMemRequest string `json:"logMemRequest,omitempty"`

	// node selector
	NodeSelector []*NodeSelector `json:"nodeSelector"`

	// security context
	SecurityContext *SecurityContext `json:"securityContext,omitempty"`

	// service account name
	ServiceAccountName string `json:"serviceAccountName,omitempty"`
}

// Validate validates this tenant logs
func (m *TenantLogs) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateAnnotations(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDbAnnotations(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDbLabels(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDbNodeSelector(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateDbSecurityContext(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateLabels(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateNodeSelector(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateSecurityContext(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TenantLogs) validateAnnotations(formats strfmt.Registry) error {
	if swag.IsZero(m.Annotations) { // not required
		return nil
	}

	for i := 0; i < len(m.Annotations); i++ {
		if swag.IsZero(m.Annotations[i]) { // not required
			continue
		}

		if m.Annotations[i] != nil {
			if err := m.Annotations[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("annotations" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("annotations" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *TenantLogs) validateDbAnnotations(formats strfmt.Registry) error {
	if swag.IsZero(m.DbAnnotations) { // not required
		return nil
	}

	for i := 0; i < len(m.DbAnnotations); i++ {
		if swag.IsZero(m.DbAnnotations[i]) { // not required
			continue
		}

		if m.DbAnnotations[i] != nil {
			if err := m.DbAnnotations[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("dbAnnotations" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("dbAnnotations" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *TenantLogs) validateDbLabels(formats strfmt.Registry) error {
	if swag.IsZero(m.DbLabels) { // not required
		return nil
	}

	for i := 0; i < len(m.DbLabels); i++ {
		if swag.IsZero(m.DbLabels[i]) { // not required
			continue
		}

		if m.DbLabels[i] != nil {
			if err := m.DbLabels[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("dbLabels" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("dbLabels" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *TenantLogs) validateDbNodeSelector(formats strfmt.Registry) error {
	if swag.IsZero(m.DbNodeSelector) { // not required
		return nil
	}

	for i := 0; i < len(m.DbNodeSelector); i++ {
		if swag.IsZero(m.DbNodeSelector[i]) { // not required
			continue
		}

		if m.DbNodeSelector[i] != nil {
			if err := m.DbNodeSelector[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("dbNodeSelector" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("dbNodeSelector" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *TenantLogs) validateDbSecurityContext(formats strfmt.Registry) error {
	if swag.IsZero(m.DbSecurityContext) { // not required
		return nil
	}

	if m.DbSecurityContext != nil {
		if err := m.DbSecurityContext.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dbSecurityContext")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("dbSecurityContext")
			}
			return err
		}
	}

	return nil
}

func (m *TenantLogs) validateLabels(formats strfmt.Registry) error {
	if swag.IsZero(m.Labels) { // not required
		return nil
	}

	for i := 0; i < len(m.Labels); i++ {
		if swag.IsZero(m.Labels[i]) { // not required
			continue
		}

		if m.Labels[i] != nil {
			if err := m.Labels[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("labels" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("labels" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *TenantLogs) validateNodeSelector(formats strfmt.Registry) error {
	if swag.IsZero(m.NodeSelector) { // not required
		return nil
	}

	for i := 0; i < len(m.NodeSelector); i++ {
		if swag.IsZero(m.NodeSelector[i]) { // not required
			continue
		}

		if m.NodeSelector[i] != nil {
			if err := m.NodeSelector[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nodeSelector" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("nodeSelector" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *TenantLogs) validateSecurityContext(formats strfmt.Registry) error {
	if swag.IsZero(m.SecurityContext) { // not required
		return nil
	}

	if m.SecurityContext != nil {
		if err := m.SecurityContext.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("securityContext")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("securityContext")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this tenant logs based on the context it is used
func (m *TenantLogs) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateAnnotations(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDbAnnotations(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDbLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDbNodeSelector(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateDbSecurityContext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateLabels(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateNodeSelector(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateSecurityContext(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *TenantLogs) contextValidateAnnotations(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Annotations); i++ {

		if m.Annotations[i] != nil {
			if err := m.Annotations[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("annotations" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("annotations" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *TenantLogs) contextValidateDbAnnotations(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DbAnnotations); i++ {

		if m.DbAnnotations[i] != nil {
			if err := m.DbAnnotations[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("dbAnnotations" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("dbAnnotations" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *TenantLogs) contextValidateDbLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DbLabels); i++ {

		if m.DbLabels[i] != nil {
			if err := m.DbLabels[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("dbLabels" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("dbLabels" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *TenantLogs) contextValidateDbNodeSelector(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.DbNodeSelector); i++ {

		if m.DbNodeSelector[i] != nil {
			if err := m.DbNodeSelector[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("dbNodeSelector" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("dbNodeSelector" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *TenantLogs) contextValidateDbSecurityContext(ctx context.Context, formats strfmt.Registry) error {

	if m.DbSecurityContext != nil {
		if err := m.DbSecurityContext.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("dbSecurityContext")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("dbSecurityContext")
			}
			return err
		}
	}

	return nil
}

func (m *TenantLogs) contextValidateLabels(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Labels); i++ {

		if m.Labels[i] != nil {
			if err := m.Labels[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("labels" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("labels" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *TenantLogs) contextValidateNodeSelector(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.NodeSelector); i++ {

		if m.NodeSelector[i] != nil {
			if err := m.NodeSelector[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("nodeSelector" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("nodeSelector" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *TenantLogs) contextValidateSecurityContext(ctx context.Context, formats strfmt.Registry) error {

	if m.SecurityContext != nil {
		if err := m.SecurityContext.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("securityContext")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("securityContext")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *TenantLogs) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *TenantLogs) UnmarshalBinary(b []byte) error {
	var res TenantLogs
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
