// Code generated by go-swagger; DO NOT EDIT.

// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

package operator_api

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"net/http"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/runtime/middleware"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// NewGetAllocatableResourcesParams creates a new GetAllocatableResourcesParams object
//
// There are no default values defined in the spec.
func NewGetAllocatableResourcesParams() GetAllocatableResourcesParams {

	return GetAllocatableResourcesParams{}
}

// GetAllocatableResourcesParams contains all the bound params for the get allocatable resources operation
// typically these are obtained from a http.Request
//
// swagger:parameters GetAllocatableResources
type GetAllocatableResourcesParams struct {

	// HTTP Request Object
	HTTPRequest *http.Request `json:"-"`

	/*
	  Required: true
	  Minimum: 1
	  In: query
	*/
	NumNodes int32
}

// BindRequest both binds and validates a request, it assumes that complex things implement a Validatable(strfmt.Registry) error interface
// for simple values it will use straight method calls.
//
// To ensure default values, the struct must have been initialized with NewGetAllocatableResourcesParams() beforehand.
func (o *GetAllocatableResourcesParams) BindRequest(r *http.Request, route *middleware.MatchedRoute) error {
	var res []error

	o.HTTPRequest = r

	qs := runtime.Values(r.URL.Query())

	qNumNodes, qhkNumNodes, _ := qs.GetOK("num_nodes")
	if err := o.bindNumNodes(qNumNodes, qhkNumNodes, route.Formats); err != nil {
		res = append(res, err)
	}
	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindNumNodes binds and validates parameter NumNodes from query.
func (o *GetAllocatableResourcesParams) bindNumNodes(rawData []string, hasKey bool, formats strfmt.Registry) error {
	if !hasKey {
		return errors.Required("num_nodes", "query", rawData)
	}
	var raw string
	if len(rawData) > 0 {
		raw = rawData[len(rawData)-1]
	}

	// Required: true
	// AllowEmptyValue: false

	if err := validate.RequiredString("num_nodes", "query", raw); err != nil {
		return err
	}

	value, err := swag.ConvertInt32(raw)
	if err != nil {
		return errors.InvalidType("num_nodes", "query", "int32", raw)
	}
	o.NumNodes = value

	if err := o.validateNumNodes(formats); err != nil {
		return err
	}

	return nil
}

// validateNumNodes carries on validations for parameter NumNodes
func (o *GetAllocatableResourcesParams) validateNumNodes(formats strfmt.Registry) error {

	if err := validate.MinimumInt("num_nodes", "query", int64(o.NumNodes), 1, false); err != nil {
		return err
	}

	return nil
}
