/*
Copyright 2020 Google LLC

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    https://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta2

import (
	"context"
	"time"

	v1beta2 "github.com/minio/console/pkg/apis/networking.gke.io/v1beta2"
	scheme "github.com/minio/console/pkg/clientgen/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ManagedCertificatesGetter has a method to return a ManagedCertificateInterface.
// A group's client should implement this interface.
type ManagedCertificatesGetter interface {
	ManagedCertificates(namespace string) ManagedCertificateInterface
}

// ManagedCertificateInterface has methods to work with ManagedCertificate resources.
type ManagedCertificateInterface interface {
	Create(ctx context.Context, managedCertificate *v1beta2.ManagedCertificate, opts v1.CreateOptions) (*v1beta2.ManagedCertificate, error)
	Update(ctx context.Context, managedCertificate *v1beta2.ManagedCertificate, opts v1.UpdateOptions) (*v1beta2.ManagedCertificate, error)
	UpdateStatus(ctx context.Context, managedCertificate *v1beta2.ManagedCertificate, opts v1.UpdateOptions) (*v1beta2.ManagedCertificate, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v1beta2.ManagedCertificate, error)
	List(ctx context.Context, opts v1.ListOptions) (*v1beta2.ManagedCertificateList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta2.ManagedCertificate, err error)
	ManagedCertificateExpansion
}

// managedCertificates implements ManagedCertificateInterface
type managedCertificates struct {
	client rest.Interface
	ns     string
}

// newManagedCertificates returns a ManagedCertificates
func newManagedCertificates(c *NetworkingV1beta2Client, namespace string) *managedCertificates {
	return &managedCertificates{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the managedCertificate, and returns the corresponding managedCertificate object, and an error if there is any.
func (c *managedCertificates) Get(ctx context.Context, name string, options v1.GetOptions) (result *v1beta2.ManagedCertificate, err error) {
	result = &v1beta2.ManagedCertificate{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("managedcertificates").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ManagedCertificates that match those selectors.
func (c *managedCertificates) List(ctx context.Context, opts v1.ListOptions) (result *v1beta2.ManagedCertificateList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta2.ManagedCertificateList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("managedcertificates").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested managedCertificates.
func (c *managedCertificates) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("managedcertificates").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a managedCertificate and creates it.  Returns the server's representation of the managedCertificate, and an error, if there is any.
func (c *managedCertificates) Create(ctx context.Context, managedCertificate *v1beta2.ManagedCertificate, opts v1.CreateOptions) (result *v1beta2.ManagedCertificate, err error) {
	result = &v1beta2.ManagedCertificate{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("managedcertificates").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(managedCertificate).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a managedCertificate and updates it. Returns the server's representation of the managedCertificate, and an error, if there is any.
func (c *managedCertificates) Update(ctx context.Context, managedCertificate *v1beta2.ManagedCertificate, opts v1.UpdateOptions) (result *v1beta2.ManagedCertificate, err error) {
	result = &v1beta2.ManagedCertificate{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("managedcertificates").
		Name(managedCertificate.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(managedCertificate).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *managedCertificates) UpdateStatus(ctx context.Context, managedCertificate *v1beta2.ManagedCertificate, opts v1.UpdateOptions) (result *v1beta2.ManagedCertificate, err error) {
	result = &v1beta2.ManagedCertificate{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("managedcertificates").
		Name(managedCertificate.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(managedCertificate).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the managedCertificate and deletes it. Returns an error if one occurs.
func (c *managedCertificates) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("managedcertificates").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *managedCertificates) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("managedcertificates").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched managedCertificate.
func (c *managedCertificates) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v1beta2.ManagedCertificate, err error) {
	result = &v1beta2.ManagedCertificate{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("managedcertificates").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
