// This file is part of MinIO Console Server
// Copyright (c) 2022 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const AGPLV3Logo = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={"min-icon"}
    fill={"currentcolor"}
    {...props}
    viewBox="0 0 117.104 38.414"
  >
    <g id="ConsoleAGPLV3-Logo-License" transform="translate(6804.003 4884.319)">
      <g id="agpl-logo" transform="translate(-6804.003 -4884.319)">
        <g id="g2" transform="translate(0 0)">
          <path
            id="path1"
            d="M111.872,1769.742l-8.188,35.724h79.124a7.037,7.037,0,0,1-5.3-2.53,5.366,5.366,0,0,1-.522-.89c-.094-.232-.183-.464-.272-.7a7.08,7.08,0,0,1-.287-2.464,17.963,17.963,0,0,1,3.281-8.475,45.721,45.721,0,0,1,9.041-9.865c.857-.711,1.743-1.414,2.671-2.1,1.146-.843,2.3-1.62,3.458-2.347a43.96,43.96,0,0,1,12.271-5.51,47.417,47.417,0,0,0-11.631,5.878c-.144.1-.285.2-.427.294a52.021,52.021,0,0,0-5.974,4.812c-5.636,5.3-8.615,10.79-7.261,14.007a4,4,0,0,0,.346.632c1.455,2.139,5.06,2.51,9.63,1.361.311-.077.622-.166.942-.258a37.1,37.1,0,0,0,4.605-1.691c.384-.17.771-.344,1.162-.53.04-.019.078-.037.118-.059,5.038-2.5,8.909-5.383,9.748-7.113a1.076,1.076,0,0,0,.1-.949c-.6-1.213-4.782-.394-9.851,1.8-.407.176-.819.358-1.236.551.339-.314.692-.63,1.052-.942.574-.495,1.169-.978,1.8-1.456a35.749,35.749,0,0,1,2.979-2.031c4.619-3.485,6.954-6.781,6.467-8a.861.861,0,0,0-.589-.486c-.963-.306-2.72.059-4.855.935a36.256,36.256,0,0,0-5.834,3.126l-.28.184-.051.03-.986.653.566-1.037a17.819,17.819,0,0,1,3.914-4.634,27.8,27.8,0,0,1,4.215-3.017c.582-.34,1.162-.656,1.744-.94s1.191-.55,1.773-.781a20.5,20.5,0,0,1,4.951-1.623c-.128,0-4.194.438-4.194.438H111.872Zm63.778.051c-.231,3.521.452,8.679,2,14.4q.413,1.53.9,3.106.307.971.633,1.911c-.127.187-.255.373-.375.56a19.777,19.777,0,0,0-3.347,8.2,50.449,50.449,0,0,1-1.78-8.909q-.148-1.366-.228-2.7c-.381-6.461.462-12.317,2.192-16.568Zm-38.571,4.583c.044,0,.087,0,.132,0h8.7a3.042,3.042,0,0,1,1.729.419.985.985,0,0,1,.464,1.089l-1.037,4.686H144l1.008-4.561h-7.68l-2.773,12.536-1,4.539h7.673l.007-.029,1.538-6.946h-3.6l.346-1.567h6.672l-1.913,8.667a1.226,1.226,0,0,1-.132.345,1.916,1.916,0,0,1-.816.736,4.054,4.054,0,0,1-1.913.419h-8.7a3.037,3.037,0,0,1-1.729-.419.97.97,0,0,1-.463-1.081l3.833-17.326a1.661,1.661,0,0,1,.942-1.089c.019-.009.04-.011.059-.022a4.014,4.014,0,0,1,1.722-.4Zm13.639,0h10.954a3.037,3.037,0,0,1,1.721.419.98.98,0,0,1,.471,1.089l-2.045,9.24a1.658,1.658,0,0,1-.949,1.081,4.025,4.025,0,0,1-1.905.427h-7.96l-1.538,6.938-.25,1.14h-3l.228-1.03,4.274-19.3Zm15.133,0h3l-3.4,15.353-.743,3.355h7.18c.075.55.163,1.091.258,1.626h-10.8l.853-3.856Zm-12.492,1.633-1.994,8.99h7.482l1.986-8.99Zm-15.954,21.218c.029,0,.059,0,.088,0a2.111,2.111,0,0,1,.9.176,1.068,1.068,0,0,1,.552.545,1.329,1.329,0,0,1,.074.787l-.022.11h-.861l.007-.1a.679.679,0,0,0-.081-.471.471.471,0,0,0-.037-.044.518.518,0,0,0-.074-.059,1.063,1.063,0,0,0-.552-.118,1.284,1.284,0,0,0-.728.17.647.647,0,0,0-.294.382.283.283,0,0,0,.059.272l.007.007a2.009,2.009,0,0,0,.728.258,4.948,4.948,0,0,1,.949.3,1.121,1.121,0,0,1,.544.523,1.145,1.145,0,0,1,.059.729,1.669,1.669,0,0,1-.39.728,1.973,1.973,0,0,1-.743.529,2.506,2.506,0,0,1-.956.191,2.384,2.384,0,0,1-1.03-.191,1.184,1.184,0,0,1-.6-.61,1.5,1.5,0,0,1-.074-.89l.022-.1h.846l-.007.1a.93.93,0,0,0,.051.471.578.578,0,0,0,.294.28,1.365,1.365,0,0,0,.589.117,1.626,1.626,0,0,0,.559-.1.986.986,0,0,0,.39-.236.653.653,0,0,0,.169-.316.348.348,0,0,0-.022-.257.537.537,0,0,0-.272-.2l-.721-.214a3.2,3.2,0,0,1-.831-.294,1.029,1.029,0,0,1-.449-.486,1.043,1.043,0,0,1-.037-.639,1.555,1.555,0,0,1,.36-.7,1.8,1.8,0,0,1,.721-.493A2.532,2.532,0,0,1,137.406,1797.228Zm7.725.014c.047,0,.09,0,.14,0l.53.059.177.015-.257.654-.052.1-.4-.037a.469.469,0,0,0-.265.058l-.015.016a.164.164,0,0,0-.029.028.7.7,0,0,0-.11.279s-.015.064-.029.118h.633l-.162.729h-.618c-.047.212-.625,2.8-.625,2.8h-.853s.555-2.49.625-2.8h-.493l.162-.729h.485c.024-.1.059-.228.059-.228a1.807,1.807,0,0,1,.177-.522,1.11,1.11,0,0,1,.4-.4,1.238,1.238,0,0,1,.522-.147Zm2.038.037-.28,1.257h.552l-.162.729h-.552c-.045.2-.4,1.773-.4,1.773s-.029.189-.029.243c0,0,0,.005,0,.007s0,.007,0,.007h.007l.088.007.4-.029-.044.656.007.117-.581.066a.944.944,0,0,1-.522-.117.524.524,0,0,1-.235-.339.548.548,0,0,1-.015-.118,3.014,3.014,0,0,1,.088-.6s.309-1.386.375-1.677h-.4l.162-.729h.4c.038-.17.169-.75.169-.75l.684-.361.28-.146Zm-27.109.028h3.31l-.184.824h-2.42c-.038.166-.189.844-.243,1.089h2.1l-.184.824h-2.1c-.045.206-.449,2.024-.449,2.024H119Zm4.436,1.163a.905.905,0,0,1,.1,0,1,1,0,0,1,.6.2l.118.081-.456.75-.125-.088a.532.532,0,0,0-.294-.089.46.46,0,0,0-.257.089.641.641,0,0,0-.221.243,2.32,2.32,0,0,0-.221.6l-.4,1.81h-.853l.787-3.532h.794s-.027.107-.037.148c.038-.029.077-.068.11-.089A.9.9,0,0,1,124.5,1798.471Zm2.531,0c.051,0,.1,0,.155,0a1.247,1.247,0,0,1,1.081.5,1.363,1.363,0,0,1,.228.794,2.659,2.659,0,0,1-.066.567l-.066.257h-2.4c0,.051-.007.1-.007.148a.7.7,0,0,0,.118.433.534.534,0,0,0,.132.133.652.652,0,0,0,.36.1.845.845,0,0,0,.471-.14,1.235,1.235,0,0,0,.383-.419h.912l-.081.177a2.017,2.017,0,0,1-.721.823,1.945,1.945,0,0,1-1.067.3,1.327,1.327,0,0,1-1.148-.5,1.609,1.609,0,0,1-.162-1.34,2.439,2.439,0,0,1,.75-1.353,1.906,1.906,0,0,1,1.126-.478Zm3.833,0c.051,0,.1,0,.154,0a1.247,1.247,0,0,1,1.081.5,1.363,1.363,0,0,1,.228.794,2.591,2.591,0,0,1-.066.559l-.066.264h-2.4c0,.034-.005.064-.007.1,0,.012,0,.031,0,.044s0,0,0,.008c0,.034,0,.069.007.1a.635.635,0,0,0,.11.331c.012.017.023.037.037.052a.6.6,0,0,0,.456.176.839.839,0,0,0,.471-.14,1.233,1.233,0,0,0,.383-.419h.92l-.088.177a2.017,2.017,0,0,1-.721.823,1.945,1.945,0,0,1-1.067.3,1.226,1.226,0,0,1-1.376-1.3c0-.049,0-.1.007-.154a2.667,2.667,0,0,1,.059-.383,2.439,2.439,0,0,1,.743-1.353A1.926,1.926,0,0,1,130.859,1798.471Zm10.439,0c.053,0,.1,0,.155,0a1.309,1.309,0,0,1,1.111.493,1.569,1.569,0,0,1,.177,1.324,2.724,2.724,0,0,1-.427,1.038,2.023,2.023,0,0,1-1.611.816,1.289,1.289,0,0,1-1.111-.5,1.317,1.317,0,0,1-.235-.8,2.523,2.523,0,0,1,.066-.566,2.307,2.307,0,0,1,.853-1.42,1.983,1.983,0,0,1,1.023-.383Zm12.926,0c.062,0,.12,0,.184,0a1.873,1.873,0,0,1,.706.1.772.772,0,0,1,.4.308.845.845,0,0,1,.11.449l-.088.538-.162.728a7.979,7.979,0,0,0-.177.941.948.948,0,0,0,.037.339l.059.192h-.868l-.037-.111a1.047,1.047,0,0,1-.015-.176,2.594,2.594,0,0,1-.478.243,2.071,2.071,0,0,1-.677.118,1.114,1.114,0,0,1-.876-.309.782.782,0,0,1-.2-.544,1.191,1.191,0,0,1,.029-.25,1.225,1.225,0,0,1,.228-.493,1.371,1.371,0,0,1,.4-.354,1.775,1.775,0,0,1,.478-.191l.522-.088a5.716,5.716,0,0,0,.92-.169.458.458,0,0,1,.015-.051.47.47,0,0,0-.007-.324s-.012-.012-.015-.015a.391.391,0,0,0-.029-.029.722.722,0,0,0-.441-.1.974.974,0,0,0-.515.11.955.955,0,0,0-.316.4h-.89l.081-.177a1.881,1.881,0,0,1,.39-.6,1.61,1.61,0,0,1,.618-.36A2.445,2.445,0,0,1,154.223,1798.471Zm3.73,0a.9.9,0,0,1,.1,0,1.015,1.015,0,0,1,.6.2l.11.081-.456.75-.125-.088a.514.514,0,0,0-.287-.089.488.488,0,0,0-.265.089.642.642,0,0,0-.213.243,2.4,2.4,0,0,0-.221.6l-.4,1.81h-.853l.787-3.532h.795s-.02.107-.029.148a1.309,1.309,0,0,1,.11-.089A.857.857,0,0,1,157.953,1798.471Zm2.523,0c.051,0,.1,0,.154,0a1.244,1.244,0,0,1,1.082.5,1.346,1.346,0,0,1,.228.794,2.7,2.7,0,0,1-.074.567l-.059.257h-2.4c0,.051-.015.1-.015.148a.719.719,0,0,0,.118.433c.012.017.031.037.044.052l.029.029a.614.614,0,0,0,.427.147.845.845,0,0,0,.471-.14,1.259,1.259,0,0,0,.383-.419h.92l-.088.177a2.035,2.035,0,0,1-.721.823,1.945,1.945,0,0,1-1.067.3,1.312,1.312,0,0,1-1.14-.5,1.617,1.617,0,0,1-.169-1.34,2.43,2.43,0,0,1,.743-1.353A1.933,1.933,0,0,1,160.477,1798.471Zm-12.882.066h.875s.108,2.1.11,2.126c.035-.075.063-.137.066-.147l.964-1.979h.8s.074,2.07.074,2.082c.024-.042,1.1-2.082,1.1-2.082h.868l-1.913,3.532h-.787s-.076-1.914-.081-2.024l-.986,2.024h-.809Zm-20.555.67a.935.935,0,0,0-.559.221,1.084,1.084,0,0,0-.3.419h1.449c0-.026.007-.057.007-.081a.612.612,0,0,0-.066-.309.517.517,0,0,0-.486-.25Zm3.833,0a.936.936,0,0,0-.559.221,1.11,1.11,0,0,0-.3.419h1.449c0-.026.007-.057.007-.081a.587.587,0,0,0-.066-.309.629.629,0,0,0-.074-.1.548.548,0,0,0-.412-.154Zm29.647,0a.949.949,0,0,0-.581.221,1.137,1.137,0,0,0-.3.419h1.442c0-.026.007-.057.007-.081a.588.588,0,0,0-.066-.309.525.525,0,0,0-.486-.25Zm-19.275.015a.979.979,0,0,0-.544.266,1.593,1.593,0,0,0-.434.853,1.94,1.94,0,0,0-.052.419.723.723,0,0,0,.1.4.735.735,0,0,0,.059.074.572.572,0,0,0,.434.169.928.928,0,0,0,.647-.272,1.633,1.633,0,0,0,.434-.868,1.047,1.047,0,0,0-.044-.794.534.534,0,0,0-.486-.244C141.32,1799.221,141.282,1799.217,141.246,1799.221Zm13.293,1.288a5.367,5.367,0,0,1-.721.14,2.463,2.463,0,0,0-.471.1.527.527,0,0,0-.2.139.433.433,0,0,0-.1.192.515.515,0,0,0-.007.08s0,.005,0,.007,0,.017,0,.023a.289.289,0,0,0,.007.037s.006.011.007.014,0,.016.007.022.011.016.015.022a.322.322,0,0,0,.022.03.465.465,0,0,0,.346.1,1.169,1.169,0,0,0,.53-.118,1.028,1.028,0,0,0,.39-.338A1.363,1.363,0,0,0,154.54,1800.508Zm-44.936-5.9,19.744-20.385h3.224l-4.767,20.385h-2.652l1.354-5.868H118.23l-5.625,5.868h-3m10.637-7.968h6.769l1.249-5.118q.756-3.044,1.456-5.074-1.4,1.75-3.7,4.157l-5.775,6.034"
            transform="translate(-103.684 -1768.232)"
            fill="#fff"
          />
          <path
            id="path2"
            d="M631.974,1799.956c-2.732-.236-4.789-1.228-6-2.873a6.137,6.137,0,0,1-.6-1.028c-.113-.269-.209-.518-.307-.768l1.1-.427c.094.242.188.482.286.719a5.018,5.018,0,0,0,.475.807c1.017,1.382,2.734,2.189,5.1,2.395l2.581,0a22.475,22.475,0,0,0,2.5-.352,32.267,32.267,0,0,0,4.839-1.375c1.309-.477,2.635-1.036,3.938-1.663a55.682,55.682,0,0,0,8.9-5.387c.944-.694,1.89-1.437,2.811-2.2q1.236-1.028,2.369-2.085a22.658,22.658,0,0,0,4.519-5.8c.87-1.748,1.018-3.148.418-3.941a2.475,2.475,0,0,0-1.874-.815l-1.556-.12,1.249-.937c4.467-3.351,6.994-7.319,6.145-9.648a2.5,2.5,0,0,0-1.6-1.474,5.106,5.106,0,0,0-1.291-.264l-1.372,0a21.024,21.024,0,0,0-7.061,1.994l-.518-1.057a22.329,22.329,0,0,1,7.537-2.112h1.464a6.307,6.307,0,0,1,1.641.332,3.639,3.639,0,0,1,2.3,2.179c.968,2.657-1.24,6.664-5.541,10.2a3.012,3.012,0,0,1,1.41,1.01c.9,1.185.792,2.975-.3,5.176a23.549,23.549,0,0,1-4.763,6.125q-1.166,1.088-2.425,2.135c-.939.783-1.9,1.539-2.867,2.247a56.9,56.9,0,0,1-9.089,5.5c-1.338.644-2.7,1.219-4.044,1.709a33.472,33.472,0,0,1-5.016,1.424,23.259,23.259,0,0,1-2.675.371Z"
            transform="translate(-553.088 -1761.542)"
            fill="#fff"
          />
        </g>
      </g>
    </g>
  </svg>
);

export default AGPLV3Logo;
