// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const ClustersIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <path
        data-name="Uni\xF3n 41"
        d="M175.369 255.999a41.227 41.227 0 0 1-40.01-31.491h-14.736a41.3 41.3 0 0 1-39.988 31.491h-.006a41.192 41.192 0 0 1-41.152-41.145 41.068 41.068 0 0 1 14.268-31.134l-8.084-14.819a41.386 41.386 0 0 1-4.5.251A41.2 41.2 0 0 1 .007 128.003a41.2 41.2 0 0 1 41.154-41.154 41.31 41.31 0 0 1 6.041.443l7.676-14.071a41.09 41.09 0 0 1-15.393-32.069A41.194 41.194 0 0 1 80.637-.002a41.211 41.211 0 0 1 40.893 36.5h12.957a41.207 41.207 0 0 1 40.891-36.5 41.194 41.194 0 0 1 41.152 41.154 41.115 41.115 0 0 1-14.035 30.886l8.193 15.021a41.42 41.42 0 0 1 4.172-.21 41.2 41.2 0 0 1 41.148 41.154 41.273 41.273 0 0 1-41.148 41.149q-1.31 0-2.6-.082l-8.652 15.861a41.05 41.05 0 0 1 12.926 29.922 41.263 41.263 0 0 1-41.148 41.145Zm-15.461-41.145a15.479 15.479 0 0 0 15.461 15.462 15.485 15.485 0 0 0 15.471-15.462 15.515 15.515 0 0 0-15.471-15.471 15.485 15.485 0 0 0-15.461 15.473Zm-94.744 0a15.484 15.484 0 0 0 15.465 15.462 15.484 15.484 0 0 0 15.467-15.462 15.512 15.512 0 0 0-15.471-15.471 15.485 15.485 0 0 0-15.461 15.473Zm69.055-.351a41.147 41.147 0 0 1 18.393-33.922l-8.525-14.725a40.926 40.926 0 0 1-16.082 3.3 40.981 40.981 0 0 1-12.812-2.042l-8.984 15.522a41.109 41.109 0 0 1 15.578 31.87Zm61.25-35.552 6.477-11.871a41.28 41.28 0 0 1-27.734-32.58h-5.58a41.235 41.235 0 0 1-14.312 25.076l9.186 15.868a41.037 41.037 0 0 1 11.865-1.744 40.9 40.9 0 0 1 20.098 5.253Zm-133.391-.828a40.919 40.919 0 0 1 18.551-4.423 40.934 40.934 0 0 1 15.193 2.907l8.617-14.884A41.216 41.216 0 0 1 87.363 134.5h-5.582a41.378 41.378 0 0 1-26.059 31.969Zm137.309-50.119a15.477 15.477 0 0 0 15.465 15.462 15.477 15.477 0 0 0 15.461-15.462 15.5 15.5 0 0 0-15.471-15.471 15.483 15.483 0 0 0-15.455 15.472ZM128 143.467a15.477 15.477 0 0 0 15.465-15.462A15.5 15.5 0 0 0 128 112.534a15.4 15.4 0 0 0-5.734 1.1l-3.818 2.21A15.452 15.452 0 0 0 112.54 128a15.441 15.441 0 0 0 5.914 12.155l3.789 2.2a15.379 15.379 0 0 0 5.757 1.112ZM25.686 128.005a15.482 15.482 0 0 0 15.467 15.462 15.481 15.481 0 0 0 15.465-15.462 15.507 15.507 0 0 0-15.465-15.471 15.49 15.49 0 0 0-15.467 15.471Zm148.379-5.5a41.276 41.276 0 0 1 26.506-33.1l-6.379-11.693a40.928 40.928 0 0 1-18.818 4.591 41.039 41.039 0 0 1-11.865-1.743l-9.17 15.843a41.135 41.135 0 0 1 14.451 26.1Zm-86.848 0a41.2 41.2 0 0 1 17.221-28.223l-8.627-14.9a40.952 40.952 0 0 1-15.176 2.925h-.006a40.908 40.908 0 0 1-17.254-3.794l-6.3 11.548a41.266 41.266 0 0 1 24.863 32.448Zm56.881-32.375 8.514-14.707a41.2 41.2 0 0 1-18.049-28.922h-13.135a41.238 41.238 0 0 1-15.242 26.844l9 15.549A41 41 0 0 1 128 86.852a40.932 40.932 0 0 1 16.1 3.278Zm15.811-48.976a15.476 15.476 0 0 0 15.461 15.461 15.482 15.482 0 0 0 15.471-15.461 15.515 15.515 0 0 0-15.471-15.471 15.484 15.484 0 0 0-15.462 15.471Zm-94.744 0A15.481 15.481 0 0 0 80.63 56.615a15.481 15.481 0 0 0 15.467-15.461 15.512 15.512 0 0 0-15.471-15.471 15.484 15.484 0 0 0-15.462 15.471Z"
      />
      <path data-name="Rect\xE1ngulo 924" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default ClustersIcon;
