// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const FilePdfIcon = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    className={`min-icon`}
    fill={"currentcolor"}
    viewBox="0 0 256 256"
    {...props}
  >
    <defs>
      <clipPath id="prefix__a">
        <path d="M0 0h256v256H0z" />
      </clipPath>
    </defs>
    <g clipPath="url(#prefix__a)">
      <path fill="none" d="M0 0h256v256H0z" />
      <path
        data-name="Trazado 463"
        d="M235.994 77.198c.387-15.753.958-32.242-.5-47.941-1.092-11.756-6.191-21.735-17.831-25.915a42.409 42.409 0 0 0-5.016-1.447c-6.549-1.479-13.432-1.6-20.09-1.8-11.726-.345-23.448.365-35.176.314-23.494-.1-46.985.322-70.479.414q-4.228.016-8.456.017H36.24A17.26 17.26 0 0 0 19 18.082v220.679a17.26 17.26 0 0 0 17.24 17.24h182.537a17.26 17.26 0 0 0 17.241-17.24V128.816c0-17.184-.441-34.459-.024-51.618Zm-20.921 145.986a14.89 14.89 0 0 1-14.888 14.889H51.816a14.889 14.889 0 0 1-14.888-14.888V33.662a14.888 14.888 0 0 1 14.888-14.888h99.547v25.458a37.8 37.8 0 0 0 37.757 37.759h25.953Zm0-157.657H189.12a21.32 21.32 0 0 1-21.3-21.3V18.769h32.359a14.887 14.887 0 0 1 14.888 14.888Z"
      />
      <path
        data-name="Trazado 464"
        d="M151.162 161.256c-3.776-4.195-7.131-8.391-10.908-13a132.358 132.358 0 0 1-11.746-16.361c3.775-13.424 7.132-28.946 3.775-39.015-2.517-7.551-8.39-11.326-16.361-10.487-8.81 1.257-14.263 7.131-14.263 16.36-.42 10.488 5.873 23.913 12.586 35.24a167.721 167.721 0 0 1-6.293 16.78 171.9 171.9 0 0 1-8.39 17.62c-4.615.839-9.23 2.517-13.425 3.775-11.746 4.2-20.136 8.81-24.331 14.263-5.455 6.293-5.035 14.263.419 20.557 3.355 3.775 7.132 5.454 11.327 5.454a17.615 17.615 0 0 0 8.81-2.518q9.439-5.663 20.138-21.4a80.8 80.8 0 0 0 5.454-8.81c5.036-1.258 10.488-2.1 15.942-2.936a212.07 212.07 0 0 1 21.814-2.1c9.649 10.069 22.235 20.557 33.142 21.814 8.391 1.259 15.1-2.937 17.619-11.327 2.1-7.551-.838-13.845-8.39-18.039-8.392-4.612-22.237-5.87-36.919-5.87Zm-74.673 37.756c-3.357 1.677-3.776.839-4.615 0-1.677-2.1-1.677-2.937-.42-4.2 2.937-3.355 9.649-7.132 18.459-10.067-4.615 6.719-9.65 11.749-13.425 14.267Zm41.112-103.62c1.678 0 2.1 0 2.937 2.1 1.258 3.775.839 10.487-.839 18.877-3.356-7.131-5.033-13-5.033-17.2 0-3.357 1.256-3.357 2.934-3.776Zm4.615 69.219a32.317 32.317 0 0 0-6.293.84c1.259-2.937 2.937-5.874 4.2-9.23.839-2.1 2.1-5.034 3.356-8.391 2.517 3.776 5.035 7.132 6.713 9.65.838 1.257 2.517 3.355 4.615 5.873-4.2 0-8.4.84-12.592 1.258Zm62.088 17.2c-1.259 2.938-2.1 2.938-3.775 2.518-4.2-.419-9.649-3.776-15.941-9.229a52.838 52.838 0 0 1 17.619 3.776c2.515 1.676 2.515 2.1 2.1 2.935Z"
      />
      <path data-name="Rect\xE1ngulo 906" fill="none" d="M0 0h256v256H0z" />
    </g>
  </svg>
);

export default FilePdfIcon;
