// This file is part of MinIO Console Server
// Copyright (c) 2021 MinIO, Inc.
//
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU Affero General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Affero General Public License for more details.
//
// You should have received a copy of the GNU Affero General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.

import * as React from "react";
import { SVGProps } from "react";

const LoginMinIOLogo = (props: SVGProps<SVGSVGElement>) => (
  <svg
    xmlns="http://www.w3.org/2000/svg"
    viewBox="0 0 284.616 49.568"
    className={"min-icon"}
    fill={"currentcolor"}
    {...props}
  >
    <g transform="translate(0.5 0.5)">
      <path
        d="M10822.423,3589.089c0-14.873,14.033-24.285,33.612-24.285s33.7,9.328,33.7,24.285-13.782,24.282-33.7,24.282C10836.374,3613.371,10822.423,3604.046,10822.423,3589.089Zm7.731,0c0,11.763,11.263,18.065,25.881,18.065s25.966-6.3,25.966-18.065c0-11.681-11.345-18.068-25.966-18.068S10830.154,3577.408,10830.154,3589.089Zm-43.43,23.094-41.918-22.23a1.586,1.586,0,0,0-2.329,1.4v21.011H10726.5v-42.123a4.421,4.421,0,0,1,4.42-4.422h.029a4.4,4.4,0,0,1,2.077.519l41.752,22.233a1.587,1.587,0,0,0,2.334-1.4v-21.35h16.11v42.454a4.42,4.42,0,0,1-6.493,3.905Zm-88.75.186v-46.534h15.884v46.534Zm-28.218,0v-20.147a1.588,1.588,0,0,0-2.392-1.367l-19.068,11.186a5.668,5.668,0,0,1-5.818-.055l-18.07-11.057a1.589,1.589,0,0,0-2.416,1.355v20.084h-15.876v-42.323a4.423,4.423,0,0,1,4.423-4.422h.038a4.453,4.453,0,0,1,2.3.648l32.246,19.694a1.429,1.429,0,0,0,1.5,0l32.243-19.694a4.453,4.453,0,0,1,2.3-.648h.041a4.421,4.421,0,0,1,4.42,4.422v42.323Zm136.353-.011v-46.534h7.39v46.534Z"
        transform="translate(-10606.116 -3564.803)"
        strokeWidth="1"
      />
    </g>
  </svg>
);

export default LoginMinIOLogo;
